/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.runtime.state.memory.MemHeapKvState;
import org.apache.flink.runtime.state.memory.SerializedStateHandle;

public class MemoryStateBackend
extends StateBackend<MemoryStateBackend> {
    private static final long serialVersionUID = 4109305377809414635L;
    private static final int DEFAULT_MAX_STATE_SIZE = 0x500000;
    private final int maxStateSize;
    private static final MemoryStateBackend DEFAULT_INSTANCE = new MemoryStateBackend();

    public MemoryStateBackend() {
        this(0x500000);
    }

    public MemoryStateBackend(int maxStateSize) {
        this.maxStateSize = maxStateSize;
    }

    @Override
    public void initializeForJob(JobID job) {
    }

    @Override
    public void disposeAllStateForCurrentJob() {
    }

    @Override
    public void close() throws Exception {
    }

    public <K, V> MemHeapKvState<K, V> createKvState(TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer, V defaultValue) {
        return new MemHeapKvState<K, V>(keySerializer, valueSerializer, defaultValue);
    }

    @Override
    public <S extends Serializable> StateHandle<S> checkpointStateSerializable(S state, long checkpointID, long timestamp) throws Exception {
        SerializedStateHandle<S> handle = new SerializedStateHandle<S>(state);
        MemoryStateBackend.checkSize(handle.getSizeOfSerializedState(), this.maxStateSize);
        return new SerializedStateHandle<S>(state);
    }

    @Override
    public StateBackend.CheckpointStateOutputStream createCheckpointStateOutputStream(long checkpointID, long timestamp) throws Exception {
        return new MemoryCheckpointOutputStream(this.maxStateSize);
    }

    public String toString() {
        return "MemoryStateBackend (data in heap memory / checkpoints to JobManager)";
    }

    static void checkSize(int size, int maxSize) throws IOException {
        if (size > maxSize) {
            throw new IOException("Size of the state is larger than the maximum permitted memory-backed state. Size=" + size + " , maxSize=" + maxSize + " . Consider using a different state backend, like the File System State backend.");
        }
    }

    public static MemoryStateBackend defaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static final class MemoryCheckpointOutputStream
    extends StateBackend.CheckpointStateOutputStream {
        private final ByteArrayOutputStream os = new ByteArrayOutputStream();
        private final int maxSize;
        private boolean closed;

        public MemoryCheckpointOutputStream(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        public void write(int b) {
            this.os.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.os.write(b, off, len);
        }

        @Override
        public void close() {
            this.closed = true;
            this.os.reset();
        }

        @Override
        public StreamStateHandle closeAndGetHandle() throws IOException {
            return new ByteStreamStateHandle(this.closeAndGetBytes());
        }

        public byte[] closeAndGetBytes() throws IOException {
            if (!this.closed) {
                MemoryStateBackend.checkSize(this.os.size(), this.maxSize);
                byte[] bytes = this.os.toByteArray();
                this.close();
                return bytes;
            }
            throw new IllegalStateException("stream has already been closed");
        }
    }
}

