/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.StateHandle;
import org.apache.flink.runtime.util.SerializedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateForTask {
    private static final Logger LOG = LoggerFactory.getLogger(StateForTask.class);
    private final SerializedValue<StateHandle<?>> state;
    private final JobVertexID operatorId;
    private final int subtask;

    public StateForTask(SerializedValue<StateHandle<?>> state, JobVertexID operatorId, int subtask) {
        if (state == null || operatorId == null || subtask < 0) {
            throw new IllegalArgumentException();
        }
        this.state = state;
        this.operatorId = operatorId;
        this.subtask = subtask;
    }

    public SerializedValue<StateHandle<?>> getState() {
        return this.state;
    }

    public JobVertexID getOperatorId() {
        return this.operatorId;
    }

    public int getSubtask() {
        return this.subtask;
    }

    public void discard(ClassLoader userClassLoader) {
        try {
            this.state.deserializeValue(userClassLoader).discardState();
        }
        catch (Exception e) {
            LOG.warn("Failed to discard checkpoint state: " + this, (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof StateForTask) {
            StateForTask that = (StateForTask)o;
            return this.subtask == that.subtask && this.operatorId.equals((Object)that.operatorId) && this.state.equals(that.state);
        }
        return false;
    }

    public int hashCode() {
        return this.state.hashCode() + 31 * this.operatorId.hashCode() + 43 * this.subtask;
    }

    public String toString() {
        return String.format("StateForTask %s-%d : %s", new Object[]{this.operatorId, this.subtask, this.state});
    }
}

