/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.StateForTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuccessfulCheckpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SuccessfulCheckpoint.class);
    private final JobID job;
    private final long checkpointID;
    private final long timestamp;
    private final List<StateForTask> states;

    public SuccessfulCheckpoint(JobID job, long checkpointID, long timestamp, List<StateForTask> states) {
        this.job = job;
        this.checkpointID = checkpointID;
        this.timestamp = timestamp;
        this.states = states;
    }

    public JobID getJobId() {
        return this.job;
    }

    public long getCheckpointID() {
        return this.checkpointID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<StateForTask> getStates() {
        return this.states;
    }

    public void discard(ClassLoader userClassLoader) {
        for (StateForTask state : this.states) {
            state.discard(userClassLoader);
        }
        this.states.clear();
    }

    public String toString() {
        return String.format("Checkpoint %d @ %d for %s", this.checkpointID, this.timestamp, this.job);
    }
}

