/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.event.job;

import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public abstract class AbstractEvent
implements IOReadableWritable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicLong GLOBAL_SEQUENCE_NUMBER = new AtomicLong(0L);
    private static final SimpleDateFormat DATA_FORMATTER = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private long timestamp = -1L;
    private long sequenceNumber = -1L;

    public AbstractEvent() {
    }

    public AbstractEvent(long timestamp) {
        this.timestamp = timestamp;
        this.sequenceNumber = GLOBAL_SEQUENCE_NUMBER.incrementAndGet();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getTimestampString() {
        return AbstractEvent.timestampToString(this.timestamp);
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void read(DataInputView in) throws IOException {
        this.timestamp = in.readLong();
        this.sequenceNumber = in.readLong();
    }

    public void write(DataOutputView out) throws IOException {
        out.writeLong(this.timestamp);
        out.writeLong(this.sequenceNumber);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractEvent) {
            AbstractEvent abstractEvent = (AbstractEvent)obj;
            return this.timestamp == abstractEvent.timestamp;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.timestamp ^ this.timestamp >>> 32);
    }

    public String toString() {
        return String.format("AbstractEvent #%d at %s", this.sequenceNumber, AbstractEvent.timestampToString(this.timestamp));
    }

    public static String timestampToString(long timestamp) {
        return DATA_FORMATTER.format(new Date(timestamp));
    }
}

