/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.instance;

import akka.actor.ActorRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.instance.HardwareDescription;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.instance.InstanceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceManager {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceManager.class);
    private final Object lock = new Object();
    private final Map<InstanceID, Instance> registeredHostsById;
    private final Map<ActorRef, Instance> registeredHostsByConnection;
    private final Set<ActorRef> deadHosts;
    private final List<InstanceListener> instanceListeners = new ArrayList<InstanceListener>();
    private int totalNumberOfAliveTaskSlots;
    private volatile boolean isShutdown;

    public InstanceManager() {
        this.registeredHostsById = new HashMap<InstanceID, Instance>();
        this.registeredHostsByConnection = new HashMap<ActorRef, Instance>();
        this.deadHosts = new HashSet<ActorRef>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isShutdown) {
                return;
            }
            this.isShutdown = true;
            for (Instance i : this.registeredHostsById.values()) {
                i.markDead();
            }
            this.registeredHostsById.clear();
            this.registeredHostsByConnection.clear();
            this.deadHosts.clear();
            this.totalNumberOfAliveTaskSlots = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reportHeartBeat(InstanceID instanceId, byte[] lastMetricsReport) {
        if (instanceId == null) {
            throw new IllegalArgumentException("InstanceID may not be null.");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isShutdown) {
                return false;
            }
            Instance host = this.registeredHostsById.get((Object)instanceId);
            if (host == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Received heartbeat from unknown TaskManager with instance ID " + instanceId.toString() + " Possibly TaskManager was marked as dead (timed-out) earlier. " + "Reporting back that task manager is no longer known.");
                }
                return false;
            }
            host.reportHeartBeat();
            host.setMetricsReport(lastMetricsReport);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received heartbeat from TaskManager " + host);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceID registerTaskManager(ActorRef taskManager, InstanceConnectionInfo connectionInfo, HardwareDescription resources, int numberOfSlots) {
        Object object = this.lock;
        synchronized (object) {
            InstanceID id;
            if (this.isShutdown) {
                throw new IllegalStateException("InstanceManager is shut down.");
            }
            Instance prior = this.registeredHostsByConnection.get(taskManager);
            if (prior != null) {
                LOG.info("Registration attempt from TaskManager at " + taskManager.path() + ". This connection is already registered under ID " + (Object)((Object)prior.getId()));
                return null;
            }
            boolean wasDead = this.deadHosts.remove(taskManager);
            if (wasDead) {
                LOG.info("Registering TaskManager at " + taskManager.path() + " which was marked as dead earlier because of a heart-beat timeout.");
            }
            while (this.registeredHostsById.containsKey((Object)(id = new InstanceID()))) {
            }
            Instance host = new Instance(taskManager, connectionInfo, id, resources, numberOfSlots);
            this.registeredHostsById.put(id, host);
            this.registeredHostsByConnection.put(taskManager, host);
            this.totalNumberOfAliveTaskSlots += numberOfSlots;
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("Registered TaskManager at %s (%s) as %s. Current number of registered hosts is %d.", new Object[]{connectionInfo.getHostname(), taskManager.path(), id, this.registeredHostsById.size()}));
            }
            host.reportHeartBeat();
            this.notifyNewInstance(host);
            return id;
        }
    }

    public void unregisterTaskManager(ActorRef taskManager) {
        Instance host = this.registeredHostsByConnection.get(taskManager);
        if (host != null) {
            this.registeredHostsByConnection.remove(taskManager);
            this.registeredHostsById.remove((Object)host.getId());
            this.deadHosts.add(taskManager);
            host.markDead();
            this.totalNumberOfAliveTaskSlots -= host.getTotalNumberOfSlots();
            this.notifyDeadInstance(host);
            LOG.info("Unregistered task manager " + taskManager.path().address() + ". Number of " + "registered task managers " + this.getNumberOfRegisteredTaskManagers() + ". Number" + " of available slots " + this.getTotalNumberOfSlots() + ".");
        }
    }

    public boolean isRegistered(ActorRef taskManager) {
        return this.registeredHostsByConnection.containsKey(taskManager);
    }

    public int getNumberOfRegisteredTaskManagers() {
        return this.registeredHostsById.size();
    }

    public int getTotalNumberOfSlots() {
        return this.totalNumberOfAliveTaskSlots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Instance> getAllRegisteredInstances() {
        Object object = this.lock;
        synchronized (object) {
            return new HashSet<Instance>(this.registeredHostsById.values());
        }
    }

    public Instance getRegisteredInstanceById(InstanceID instanceID) {
        return this.registeredHostsById.get((Object)instanceID);
    }

    public Instance getRegisteredInstance(ActorRef ref) {
        return this.registeredHostsByConnection.get(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstanceListener(InstanceListener listener) {
        List<InstanceListener> list = this.instanceListeners;
        synchronized (list) {
            this.instanceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstanceListener(InstanceListener listener) {
        List<InstanceListener> list = this.instanceListeners;
        synchronized (list) {
            this.instanceListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNewInstance(Instance instance) {
        List<InstanceListener> list = this.instanceListeners;
        synchronized (list) {
            for (InstanceListener listener : this.instanceListeners) {
                try {
                    listener.newInstanceAvailable(instance);
                }
                catch (Throwable t) {
                    LOG.error("Notification of new instance availability failed.", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDeadInstance(Instance instance) {
        List<InstanceListener> list = this.instanceListeners;
        synchronized (list) {
            for (InstanceListener listener : this.instanceListeners) {
                try {
                    listener.instanceDied(instance);
                }
                catch (Throwable t) {
                    LOG.error("Notification of dead instance failed.", t);
                }
            }
        }
    }
}

