/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.memorymanager.AbstractPagedInputView;
import org.apache.flink.runtime.memorymanager.MemoryManager;
import org.apache.flink.runtime.util.MathUtils;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class FileChannelInputView
extends AbstractPagedInputView {
    private final BlockChannelReader<MemorySegment> reader;
    private final MemoryManager memManager;
    private final List<MemorySegment> memory;
    private final int sizeOfLastBlock;
    private int numRequestsRemaining;
    private int numBlocksRemaining;

    public FileChannelInputView(BlockChannelReader<MemorySegment> reader, MemoryManager memManager, List<MemorySegment> memory, int sizeOfLastBlock) throws IOException {
        super(0);
        Preconditions.checkNotNull(reader);
        Preconditions.checkNotNull(memManager);
        Preconditions.checkNotNull(memory);
        Preconditions.checkArgument(!reader.isClosed());
        Preconditions.checkArgument(memory.size() > 0);
        this.reader = reader;
        this.memManager = memManager;
        this.memory = memory;
        this.sizeOfLastBlock = sizeOfLastBlock;
        try {
            long channelLength = reader.getSize();
            int segmentSize = memManager.getPageSize();
            this.numBlocksRemaining = MathUtils.checkedDownCast(channelLength / (long)segmentSize);
            if (channelLength % (long)segmentSize != 0L) {
                ++this.numBlocksRemaining;
            }
            this.numRequestsRemaining = this.numBlocksRemaining;
            for (int i = 0; i < memory.size(); ++i) {
                this.sendReadRequest(memory.get(i));
            }
            this.advance();
        }
        catch (IOException e) {
            memManager.release(memory);
            throw e;
        }
    }

    public void close() throws IOException {
        this.close(false);
    }

    public void closeAndDelete() throws IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean deleteFile) throws IOException {
        try {
            this.clear();
            if (deleteFile) {
                this.reader.closeAndDelete();
            } else {
                this.reader.close();
            }
        }
        finally {
            List<MemorySegment> list = this.memory;
            synchronized (list) {
                this.memManager.release(this.memory);
                this.memory.clear();
            }
        }
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current) throws IOException {
        if (this.numBlocksRemaining <= 0) {
            this.reader.close();
            throw new EOFException();
        }
        if (current != null) {
            this.sendReadRequest(current);
        }
        --this.numBlocksRemaining;
        return this.reader.getNextReturnedBlock();
    }

    @Override
    protected int getLimitForSegment(MemorySegment segment) {
        return this.numBlocksRemaining > 0 ? segment.size() : this.sizeOfLastBlock;
    }

    private void sendReadRequest(MemorySegment seg) throws IOException {
        if (this.numRequestsRemaining > 0) {
            this.reader.readBlock(seg);
            --this.numRequestsRemaining;
        } else {
            this.memManager.release(seg);
        }
    }
}

