/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memorymanager.AbstractPagedInputView;
import org.apache.flink.runtime.memorymanager.MemoryManager;
import org.apache.flink.runtime.util.MathUtils;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class SeekableFileChannelInputView
extends AbstractPagedInputView {
    private BlockChannelReader<MemorySegment> reader;
    private final IOManager ioManager;
    private final FileIOChannel.ID channelId;
    private final MemoryManager memManager;
    private final List<MemorySegment> memory;
    private final int sizeOfLastBlock;
    private final int numBlocksTotal;
    private final int segmentSize;
    private int numRequestsRemaining;
    private int numBlocksRemaining;

    public SeekableFileChannelInputView(IOManager ioManager, FileIOChannel.ID channelId, MemoryManager memManager, List<MemorySegment> memory, int sizeOfLastBlock) throws IOException {
        super(0);
        Preconditions.checkNotNull(ioManager);
        Preconditions.checkNotNull(channelId);
        Preconditions.checkNotNull(memManager);
        Preconditions.checkNotNull(memory);
        this.ioManager = ioManager;
        this.channelId = channelId;
        this.memManager = memManager;
        this.memory = memory;
        this.sizeOfLastBlock = sizeOfLastBlock;
        this.segmentSize = memManager.getPageSize();
        this.reader = ioManager.createBlockChannelReader(channelId);
        try {
            long channelLength = this.reader.getSize();
            int blockCount = MathUtils.checkedDownCast(channelLength / (long)this.segmentSize);
            this.numRequestsRemaining = this.numBlocksRemaining = (this.numBlocksTotal = channelLength % (long)this.segmentSize == 0L ? blockCount : blockCount + 1);
            for (int i = 0; i < memory.size(); ++i) {
                this.sendReadRequest(memory.get(i));
            }
            this.advance();
        }
        catch (IOException e) {
            memManager.release(memory);
            throw e;
        }
    }

    public void seek(long position) throws IOException {
        int block = MathUtils.checkedDownCast(position / (long)this.segmentSize);
        int positionInBlock = (int)(position % (long)this.segmentSize);
        if (position < 0L || block >= this.numBlocksTotal || block == this.numBlocksTotal - 1 && positionInBlock > this.sizeOfLastBlock) {
            throw new IllegalArgumentException("Position is out of range");
        }
        this.clear();
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = this.ioManager.createBlockChannelReader(this.channelId);
        if (block > 0) {
            this.reader.seekToPosition((long)block * (long)this.segmentSize);
        }
        this.numRequestsRemaining = this.numBlocksRemaining = this.numBlocksTotal - block;
        for (int i = 0; i < this.memory.size(); ++i) {
            this.sendReadRequest(this.memory.get(i));
        }
        --this.numBlocksRemaining;
        this.seekInput(this.reader.getNextReturnedBlock(), positionInBlock, this.numBlocksRemaining == 0 ? this.sizeOfLastBlock : this.segmentSize);
    }

    public void close() throws IOException {
        this.close(false);
    }

    public void closeAndDelete() throws IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean deleteFile) throws IOException {
        try {
            this.clear();
            if (deleteFile) {
                this.reader.closeAndDelete();
            } else {
                this.reader.close();
            }
        }
        finally {
            List<MemorySegment> list = this.memory;
            synchronized (list) {
                this.memManager.release(this.memory);
                this.memory.clear();
            }
        }
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current) throws IOException {
        if (this.numBlocksRemaining <= 0) {
            this.reader.close();
            throw new EOFException();
        }
        if (current != null) {
            this.sendReadRequest(current);
        }
        --this.numBlocksRemaining;
        return this.reader.getNextReturnedBlock();
    }

    @Override
    protected int getLimitForSegment(MemorySegment segment) {
        return this.numBlocksRemaining > 0 ? segment.size() : this.sizeOfLastBlock;
    }

    private void sendReadRequest(MemorySegment seg) throws IOException {
        if (this.numRequestsRemaining > 0) {
            this.reader.readBlock(seg);
            --this.numRequestsRemaining;
        }
    }
}

