/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network;

import java.util.Map;
import org.apache.flink.runtime.event.task.TaskEvent;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.util.event.EventListener;
import org.apache.flink.shaded.com.google.common.collect.Maps;

public class TaskEventDispatcher {
    private final Map<ResultPartitionID, ResultPartitionWriter> registeredWriters = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerWriterForIncomingTaskEvents(ResultPartitionID partitionId, ResultPartitionWriter writer) {
        Map<ResultPartitionID, ResultPartitionWriter> map = this.registeredWriters;
        synchronized (map) {
            if (this.registeredWriters.put(partitionId, writer) != null) {
                throw new IllegalStateException("Already registered at task event dispatcher.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterWriter(ResultPartitionWriter writer) {
        Map<ResultPartitionID, ResultPartitionWriter> map = this.registeredWriters;
        synchronized (map) {
            this.registeredWriters.remove(writer.getPartitionId());
        }
    }

    public boolean publish(ResultPartitionID partitionId, TaskEvent event) {
        EventListener listener = this.registeredWriters.get(partitionId);
        if (listener != null) {
            listener.onEvent(event);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Map<ResultPartitionID, ResultPartitionWriter> map = this.registeredWriters;
        synchronized (map) {
            this.registeredWriters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfRegisteredWriters() {
        Map<ResultPartitionID, ResultPartitionWriter> map = this.registeredWriters;
        synchronized (map) {
            return this.registeredWriters.size();
        }
    }
}

