/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.util.DataInputDeserializer;
import org.apache.flink.runtime.util.DataOutputSerializer;

public class AdaptiveSpanningRecordDeserializer<T extends IOReadableWritable>
implements RecordDeserializer<T> {
    private final NonSpanningWrapper nonSpanningWrapper = new NonSpanningWrapper();
    private final SpanningWrapper spanningWrapper = new SpanningWrapper();
    private Buffer currentBuffer;

    @Override
    public void setNextBuffer(Buffer buffer) throws IOException {
        this.currentBuffer = buffer;
        MemorySegment segment = buffer.getMemorySegment();
        int numBytes = buffer.getSize();
        this.setNextMemorySegment(segment, numBytes);
    }

    @Override
    public Buffer getCurrentBuffer() {
        Buffer tmp = this.currentBuffer;
        this.currentBuffer = null;
        return tmp;
    }

    @Override
    public void setNextMemorySegment(MemorySegment segment, int numBytes) throws IOException {
        if (this.spanningWrapper.getNumGatheredBytes() > 0) {
            this.spanningWrapper.addNextChunkFromMemorySegment(segment, numBytes);
        } else {
            this.nonSpanningWrapper.initializeFromMemorySegment(segment, 0, numBytes);
        }
    }

    @Override
    public RecordDeserializer.DeserializationResult getNextRecord(T target) throws IOException {
        int nonSpanningRemaining = this.nonSpanningWrapper.remaining();
        if (nonSpanningRemaining >= 4) {
            int len = this.nonSpanningWrapper.readInt();
            if (len <= nonSpanningRemaining - 4) {
                target.read((DataInputView)this.nonSpanningWrapper);
                return this.nonSpanningWrapper.remaining() == 0 ? RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER : RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER;
            }
            this.spanningWrapper.initializeWithPartialRecord(this.nonSpanningWrapper, len);
            this.nonSpanningWrapper.clear();
            return RecordDeserializer.DeserializationResult.PARTIAL_RECORD;
        }
        if (nonSpanningRemaining > 0) {
            this.spanningWrapper.initializeWithPartialLength(this.nonSpanningWrapper);
            this.nonSpanningWrapper.clear();
            return RecordDeserializer.DeserializationResult.PARTIAL_RECORD;
        }
        if (this.spanningWrapper.hasFullRecord()) {
            target.read((DataInputView)this.spanningWrapper);
            this.spanningWrapper.moveRemainderToNonSpanningDeserializer(this.nonSpanningWrapper);
            this.spanningWrapper.clear();
            return this.nonSpanningWrapper.remaining() == 0 ? RecordDeserializer.DeserializationResult.LAST_RECORD_FROM_BUFFER : RecordDeserializer.DeserializationResult.INTERMEDIATE_RECORD_FROM_BUFFER;
        }
        return RecordDeserializer.DeserializationResult.PARTIAL_RECORD;
    }

    @Override
    public void clear() {
        this.nonSpanningWrapper.clear();
        this.spanningWrapper.clear();
    }

    @Override
    public boolean hasUnfinishedData() {
        return this.nonSpanningWrapper.remaining() > 0 || this.spanningWrapper.getNumGatheredBytes() > 0;
    }

    private static final class SpanningWrapper
    implements DataInputView {
        private final DataOutputSerializer serializationBuffer;
        private final DataInputDeserializer serializationReadBuffer;
        private final ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
        private int recordLength;
        private MemorySegment leftOverData;
        private int leftOverStart;
        private int leftOverLimit;
        private int recordLimit;

        public SpanningWrapper() {
            this.lengthBuffer.order(ByteOrder.BIG_ENDIAN);
            this.recordLength = -1;
            this.serializationBuffer = new DataOutputSerializer(1024);
            this.serializationReadBuffer = new DataInputDeserializer();
        }

        private void initializeWithPartialRecord(NonSpanningWrapper partial, int nextRecordLength) throws IOException {
            this.recordLength = nextRecordLength;
            this.recordLimit = partial.remaining();
            partial.segment.get((DataOutput)((Object)this.serializationBuffer), partial.position, partial.remaining());
            this.serializationReadBuffer.setBuffer(this.serializationBuffer.wrapAsByteBuffer());
        }

        private void initializeWithPartialLength(NonSpanningWrapper partial) throws IOException {
            partial.segment.get(partial.position, this.lengthBuffer, partial.remaining());
        }

        private void addNextChunkFromMemorySegment(MemorySegment segment, int numBytesInSegment) throws IOException {
            int segmentPosition = 0;
            if (this.lengthBuffer.position() > 0) {
                int toPut = Math.min(this.lengthBuffer.remaining(), numBytesInSegment);
                segment.get(0, this.lengthBuffer, toPut);
                if (this.lengthBuffer.hasRemaining()) {
                    return;
                }
                this.recordLength = this.lengthBuffer.getInt(0);
                this.lengthBuffer.clear();
                segmentPosition = toPut;
            }
            int needed = this.recordLength - this.recordLimit;
            int available = numBytesInSegment - segmentPosition;
            int toCopy = Math.min(needed, available);
            segment.get((DataOutput)((Object)this.serializationBuffer), segmentPosition, toCopy);
            this.recordLimit += toCopy;
            if (toCopy < available) {
                this.leftOverData = segment;
                this.leftOverStart = segmentPosition + toCopy;
                this.leftOverLimit = numBytesInSegment;
            }
            this.serializationReadBuffer.setBuffer(this.serializationBuffer.wrapAsByteBuffer());
        }

        private void moveRemainderToNonSpanningDeserializer(NonSpanningWrapper deserializer) {
            deserializer.clear();
            if (this.leftOverData != null) {
                deserializer.initializeFromMemorySegment(this.leftOverData, this.leftOverStart, this.leftOverLimit);
            }
        }

        private boolean hasFullRecord() {
            return this.recordLength >= 0 && this.recordLimit >= this.recordLength;
        }

        private int getNumGatheredBytes() {
            return this.recordLimit + (this.recordLength >= 0 ? 4 : this.lengthBuffer.position()) + this.serializationBuffer.length();
        }

        public void clear() {
            this.serializationBuffer.clear();
            this.serializationBuffer.pruneBuffer();
            this.serializationReadBuffer.releaseArrays();
            this.recordLength = -1;
            this.lengthBuffer.clear();
            this.leftOverData = null;
            this.recordLimit = 0;
        }

        public void readFully(byte[] b) throws IOException {
            this.serializationReadBuffer.readFully(b);
        }

        public void readFully(byte[] b, int off, int len) throws IOException {
            this.serializationReadBuffer.readFully(b, off, len);
        }

        public int skipBytes(int n) throws IOException {
            return this.serializationReadBuffer.skipBytes(n);
        }

        public boolean readBoolean() throws IOException {
            return this.serializationReadBuffer.readBoolean();
        }

        public byte readByte() throws IOException {
            return this.serializationReadBuffer.readByte();
        }

        public int readUnsignedByte() throws IOException {
            return this.serializationReadBuffer.readUnsignedByte();
        }

        public short readShort() throws IOException {
            return this.serializationReadBuffer.readShort();
        }

        public int readUnsignedShort() throws IOException {
            return this.serializationReadBuffer.readUnsignedShort();
        }

        public char readChar() throws IOException {
            return this.serializationReadBuffer.readChar();
        }

        public int readInt() throws IOException {
            return this.serializationReadBuffer.readInt();
        }

        public long readLong() throws IOException {
            return this.serializationReadBuffer.readLong();
        }

        public float readFloat() throws IOException {
            return this.serializationReadBuffer.readFloat();
        }

        public double readDouble() throws IOException {
            return this.serializationReadBuffer.readDouble();
        }

        public String readLine() throws IOException {
            return this.serializationReadBuffer.readLine();
        }

        public String readUTF() throws IOException {
            return this.serializationReadBuffer.readUTF();
        }

        public void skipBytesToRead(int numBytes) throws IOException {
            this.serializationReadBuffer.skipBytesToRead(numBytes);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.serializationReadBuffer.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            return this.serializationReadBuffer.read(b);
        }
    }

    private static final class NonSpanningWrapper
    implements DataInputView {
        private MemorySegment segment;
        private int limit;
        private int position;
        private byte[] utfByteBuffer;
        private char[] utfCharBuffer;

        private NonSpanningWrapper() {
        }

        int remaining() {
            return this.limit - this.position;
        }

        void clear() {
            this.segment = null;
            this.limit = 0;
            this.position = 0;
        }

        void initializeFromMemorySegment(MemorySegment seg, int position, int leftOverLimit) {
            this.segment = seg;
            this.position = position;
            this.limit = leftOverLimit;
        }

        public final void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length);
        }

        public final void readFully(byte[] b, int off, int len) throws IOException {
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            this.segment.get(this.position, b, off, len);
            this.position += len;
        }

        public final boolean readBoolean() throws IOException {
            return this.readByte() == 1;
        }

        public final byte readByte() throws IOException {
            return this.segment.get(this.position++);
        }

        public final int readUnsignedByte() throws IOException {
            return this.readByte() & 0xFF;
        }

        public final short readShort() throws IOException {
            short v = this.segment.getShort(this.position);
            this.position += 2;
            return v;
        }

        public final int readUnsignedShort() throws IOException {
            int v = this.segment.getShort(this.position) & 0xFFFF;
            this.position += 2;
            return v;
        }

        public final char readChar() throws IOException {
            char v = this.segment.getChar(this.position);
            this.position += 2;
            return v;
        }

        public final int readInt() throws IOException {
            int v = this.segment.getIntBigEndian(this.position);
            this.position += 4;
            return v;
        }

        public final long readLong() throws IOException {
            long v = this.segment.getLongBigEndian(this.position);
            this.position += 8;
            return v;
        }

        public final float readFloat() throws IOException {
            return Float.intBitsToFloat(this.readInt());
        }

        public final double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        public final String readLine() throws IOException {
            StringBuilder bld = new StringBuilder(32);
            try {
                int b;
                while ((b = this.readUnsignedByte()) != 10) {
                    if (b == 13) continue;
                    bld.append((char)b);
                }
            }
            catch (EOFException b) {
                // empty catch block
            }
            if (bld.length() == 0) {
                return null;
            }
            int len = bld.length();
            if (len > 0 && bld.charAt(len - 1) == '\r') {
                bld.setLength(len - 1);
            }
            return bld.toString();
        }

        public final String readUTF() throws IOException {
            int c;
            int count;
            char[] chararr;
            byte[] bytearr;
            int utflen = this.readUnsignedShort();
            if (this.utfByteBuffer == null || this.utfByteBuffer.length < utflen) {
                bytearr = new byte[utflen];
                this.utfByteBuffer = bytearr;
            } else {
                bytearr = this.utfByteBuffer;
            }
            if (this.utfCharBuffer == null || this.utfCharBuffer.length < utflen) {
                chararr = new char[utflen];
                this.utfCharBuffer = chararr;
            } else {
                chararr = this.utfCharBuffer;
            }
            int chararr_count = 0;
            this.readFully(bytearr, 0, utflen);
            for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
                chararr[chararr_count++] = (char)c;
            }
            block6: while (count < utflen) {
                c = bytearr[count] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++count;
                        chararr[chararr_count++] = (char)c;
                        continue block6;
                    }
                    case 12: 
                    case 13: {
                        if ((count += 2) > utflen) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte char2 = bytearr[count - 1];
                        if ((char2 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + count);
                        }
                        chararr[chararr_count++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                        continue block6;
                    }
                    case 14: {
                        if ((count += 3) > utflen) {
                            throw new UTFDataFormatException("malformed input: partial character at end");
                        }
                        byte char2 = bytearr[count - 2];
                        byte char3 = bytearr[count - 1];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                        }
                        chararr[chararr_count++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                        continue block6;
                    }
                }
                throw new UTFDataFormatException("malformed input around byte " + count);
            }
            return new String(chararr, 0, chararr_count);
        }

        public final int skipBytes(int n) throws IOException {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            int toSkip = Math.min(n, this.remaining());
            this.position += toSkip;
            return toSkip;
        }

        public void skipBytesToRead(int numBytes) throws IOException {
            int skippedBytes = this.skipBytes(numBytes);
            if (skippedBytes < numBytes) {
                throw new EOFException("Could not skip " + numBytes + " bytes.");
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException("Byte array b cannot be null.");
            }
            if (off < 0) {
                throw new IllegalArgumentException("The offset off cannot be negative.");
            }
            if (len < 0) {
                throw new IllegalArgumentException("The length len cannot be negative.");
            }
            int toRead = Math.min(len, this.remaining());
            this.segment.get(this.position, b, off, toRead);
            this.position += toRead;
            return toRead;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }
    }
}

