/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.event.task.AbstractEvent;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.util.DataInputDeserializer;
import org.apache.flink.runtime.util.DataOutputSerializer;
import org.apache.flink.util.InstantiationUtil;

public class EventSerializer {
    public static final BufferRecycler RECYCLER = new BufferRecycler(){

        @Override
        public void recycle(MemorySegment memorySegment) {
            memorySegment.free();
        }
    };

    public static ByteBuffer toSerializedEvent(AbstractEvent event) {
        try {
            DataOutputSerializer serializer = new DataOutputSerializer(128);
            serializer.writeUTF(event.getClass().getName());
            event.write(serializer);
            return serializer.wrapAsByteBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while serializing event.", e);
        }
    }

    public static AbstractEvent fromSerializedEvent(ByteBuffer buffer, ClassLoader classLoader) {
        try {
            Class<AbstractEvent> clazz;
            DataInputDeserializer deserializer = new DataInputDeserializer(buffer);
            String className = deserializer.readUTF();
            try {
                clazz = classLoader.loadClass(className).asSubclass(AbstractEvent.class);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load event class '" + className + "'.", e);
            }
            catch (ClassCastException e) {
                throw new RuntimeException("The class '" + className + "' is not a valid subclass of '" + AbstractEvent.class.getName() + "'.", e);
            }
            AbstractEvent event = (AbstractEvent)InstantiationUtil.instantiate(clazz, AbstractEvent.class);
            event.read(deserializer);
            return event;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while deserializing event.", e);
        }
    }

    public static Buffer toBuffer(AbstractEvent event) {
        ByteBuffer serializedEvent = EventSerializer.toSerializedEvent(event);
        Buffer buffer = new Buffer(new MemorySegment(serializedEvent.array()), RECYCLER, false);
        buffer.setSize(serializedEvent.remaining());
        return buffer;
    }

    public static AbstractEvent fromBuffer(Buffer buffer, ClassLoader classLoader) {
        return EventSerializer.fromSerializedEvent(buffer.getNioBuffer(), classLoader);
    }
}

