/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.SpillableSubpartition;
import org.apache.flink.runtime.io.network.partition.SpilledSubpartitionViewAsyncIO;
import org.apache.flink.runtime.io.network.partition.SpilledSubpartitionViewSyncIO;
import org.apache.flink.runtime.util.event.NotificationListener;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

class SpillableSubpartitionView
implements ResultSubpartitionView {
    private final SpillableSubpartition parent;
    private final BufferProvider bufferProvider;
    private final int numberOfBuffers;
    private final IOManager.IOMode ioMode;
    private ResultSubpartitionView spilledView;
    private int currentQueuePosition;
    private long currentBytesRead;
    private final AtomicBoolean isReleased = new AtomicBoolean(false);

    public SpillableSubpartitionView(SpillableSubpartition parent, BufferProvider bufferProvider, int numberOfBuffers, IOManager.IOMode ioMode) {
        this.parent = Preconditions.checkNotNull(parent);
        this.bufferProvider = Preconditions.checkNotNull(bufferProvider);
        Preconditions.checkArgument(numberOfBuffers >= 0);
        this.numberOfBuffers = numberOfBuffers;
        this.ioMode = Preconditions.checkNotNull(ioMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer getNextBuffer() throws IOException, InterruptedException {
        if (this.isReleased.get()) {
            return null;
        }
        ArrayList<Buffer> arrayList = this.parent.buffers;
        synchronized (arrayList) {
            if (this.parent.spillWriter == null) {
                if (this.currentQueuePosition < this.numberOfBuffers) {
                    Buffer buffer = this.parent.buffers.get(this.currentQueuePosition);
                    buffer.retain();
                    this.currentBytesRead += (long)(buffer.getSize() + 8);
                    ++this.currentQueuePosition;
                    return buffer;
                }
                return null;
            }
        }
        if (this.spilledView != null) {
            return this.spilledView.getNextBuffer();
        }
        if (this.parent.spillWriter.getNumberOfOutstandingRequests() > 0) {
            return null;
        }
        this.spilledView = this.ioMode.isSynchronous() ? new SpilledSubpartitionViewSyncIO(this.parent, this.bufferProvider.getMemorySegmentSize(), this.parent.spillWriter.getChannelID(), this.currentBytesRead) : new SpilledSubpartitionViewAsyncIO(this.parent, this.bufferProvider, this.parent.ioManager, this.parent.spillWriter.getChannelID(), this.currentBytesRead);
        return this.spilledView.getNextBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerListener(NotificationListener listener) throws IOException {
        if (this.spilledView == null) {
            ArrayList<Buffer> arrayList = this.parent.buffers;
            synchronized (arrayList) {
                if (this.parent.spillWriter == null) {
                    return false;
                }
            }
            if (this.parent.spillWriter.getNumberOfOutstandingRequests() > 0) {
                return this.parent.spillWriter.registerAllRequestsProcessedListener(listener);
            }
            return false;
        }
        return this.spilledView.registerListener(listener);
    }

    @Override
    public void notifySubpartitionConsumed() throws IOException {
        this.parent.onConsumedSubpartition();
    }

    @Override
    public void releaseAllResources() throws IOException {
        if (this.isReleased.compareAndSet(false, true) && this.spilledView != null) {
            this.spilledView.releaseAllResources();
        }
    }

    @Override
    public boolean isReleased() {
        return this.isReleased.get();
    }

    @Override
    public Throwable getFailureCause() {
        return this.parent.getFailureCause();
    }
}

