/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.accumulators;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.jobmanager.accumulators.JobAccumulators;
import org.apache.flink.runtime.util.SerializedValue;

public class AccumulatorManager {
    private final Map<JobID, JobAccumulators> jobAccumulators = new HashMap<JobID, JobAccumulators>();
    private final LinkedList<JobID> lru = new LinkedList();
    private int maxEntries;

    public AccumulatorManager(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIncomingAccumulators(JobID jobID, Map<String, Accumulator<?, ?>> newAccumulators) {
        Map<JobID, JobAccumulators> map = this.jobAccumulators;
        synchronized (map) {
            JobAccumulators jobAccumulators = this.jobAccumulators.get(jobID);
            if (jobAccumulators == null) {
                jobAccumulators = new JobAccumulators();
                this.jobAccumulators.put(jobID, jobAccumulators);
                this.cleanup(jobID);
            }
            jobAccumulators.processNew(newAccumulators);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getJobAccumulatorResults(JobID jobID) {
        JobAccumulators acc;
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<JobID, JobAccumulators> map = this.jobAccumulators;
        synchronized (map) {
            acc = this.jobAccumulators.get(jobID);
        }
        if (acc != null) {
            for (Map.Entry entry : acc.getAccumulators().entrySet()) {
                result.put((String)entry.getKey(), ((Accumulator)entry.getValue()).getLocalValue());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SerializedValue<Object>> getJobAccumulatorResultsSerialized(JobID jobID) throws IOException {
        JobAccumulators acc;
        Map<JobID, JobAccumulators> map = this.jobAccumulators;
        synchronized (map) {
            acc = this.jobAccumulators.get(jobID);
        }
        if (acc == null || acc.getAccumulators().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, SerializedValue<Object>> result = new HashMap<String, SerializedValue<Object>>();
        for (Map.Entry<String, Accumulator<?, ?>> entry : acc.getAccumulators().entrySet()) {
            result.put(entry.getKey(), new SerializedValue<Serializable>(entry.getValue().getLocalValue()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringifiedAccumulatorResult[] getJobAccumulatorResultsStringified(JobID jobID) throws IOException {
        JobAccumulators acc;
        Map<JobID, JobAccumulators> map = this.jobAccumulators;
        synchronized (map) {
            acc = this.jobAccumulators.get(jobID);
        }
        if (acc == null || acc.getAccumulators().isEmpty()) {
            return new StringifiedAccumulatorResult[0];
        }
        Map<String, Accumulator<?, ?>> accMap = acc.getAccumulators();
        StringifiedAccumulatorResult[] result = new StringifiedAccumulatorResult[accMap.size()];
        int i = 0;
        for (Map.Entry<String, Accumulator<?, ?>> entry : accMap.entrySet()) {
            String type = entry.getValue() == null ? "(null)" : entry.getValue().getClass().getSimpleName();
            String value = entry.getValue() == null ? "(null)" : entry.getValue().toString();
            result[i++] = new StringifiedAccumulatorResult(entry.getKey(), type, value);
        }
        return result;
    }

    private void cleanup(JobID jobId) {
        if (!this.lru.contains(jobId)) {
            this.lru.addFirst(jobId);
        }
        if (this.lru.size() > this.maxEntries) {
            JobID toRemove = this.lru.removeLast();
            this.jobAccumulators.remove(toRemove);
        }
    }
}

