/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.web;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import akka.util.Timeout;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.web.JsonFactory;
import org.apache.flink.runtime.messages.ArchiveMessages;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.messages.accumulators.AccumulatorResultStringsFound;
import org.apache.flink.runtime.messages.accumulators.AccumulatorResultsErroneous;
import org.apache.flink.runtime.messages.accumulators.AccumulatorResultsNotFound;
import org.apache.flink.runtime.messages.accumulators.RequestAccumulatorResultsStringified;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.StringUtils;
import org.eclipse.jetty.io.EofException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple3;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class JobManagerInfoServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(JobManagerInfoServlet.class);
    private final ActorRef jobmanager;
    private final ActorRef archive;
    private final FiniteDuration timeout;

    public JobManagerInfoServlet(ActorRef jobmanager, ActorRef archive, FiniteDuration timeout) {
        this.jobmanager = jobmanager;
        this.archive = archive;
        this.timeout = timeout;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block30: {
            resp.setStatus(200);
            resp.setContentType("application/json");
            try {
                if ("archive".equals(req.getParameter("get"))) {
                    Future response = Patterns.ask((ActorRef)this.archive, (Object)ArchiveMessages.getRequestArchivedJobs(), (Timeout)new Timeout(this.timeout));
                    Object result = Await.result((Awaitable)response, (Duration)this.timeout);
                    if (!(result instanceof ArchiveMessages.ArchivedJobs)) {
                        throw new RuntimeException("RequestArchiveJobs requires a response of type ArchivedJobs. Instead the response is of type " + result.getClass() + ".");
                    }
                    ArrayList<ExecutionGraph> archivedJobs = new ArrayList<ExecutionGraph>(((ArchiveMessages.ArchivedJobs)result).asJavaCollection());
                    this.writeJsonForArchive(resp.getWriter(), archivedJobs);
                } else if ("jobcounts".equals(req.getParameter("get"))) {
                    Future response = Patterns.ask((ActorRef)this.archive, (Object)ArchiveMessages.getRequestJobCounts(), (Timeout)new Timeout(this.timeout));
                    Object result = Await.result((Awaitable)response, (Duration)this.timeout);
                    if (!(result instanceof Tuple3)) {
                        throw new RuntimeException("RequestJobCounts requires a response of type Tuple3. Instead the response is of type " + result.getClass() + ".");
                    }
                    this.writeJsonForJobCounts(resp.getWriter(), (Tuple3<Integer, Integer, Integer>)((Tuple3)result));
                } else if ("job".equals(req.getParameter("get"))) {
                    String jobId = req.getParameter("job");
                    Future response = Patterns.ask((ActorRef)this.archive, (Object)new JobManagerMessages.RequestJob(JobID.fromHexString((String)jobId)), (Timeout)new Timeout(this.timeout));
                    Object result = Await.result((Awaitable)response, (Duration)this.timeout);
                    if (!(result instanceof JobManagerMessages.JobResponse)) {
                        throw new RuntimeException("RequestJob requires a response of type JobResponse. Instead the response is of type " + result.getClass());
                    }
                    JobManagerMessages.JobResponse jobResponse = (JobManagerMessages.JobResponse)result;
                    if (jobResponse instanceof JobManagerMessages.JobFound) {
                        ExecutionGraph archivedJob = ((JobManagerMessages.JobFound)result).executionGraph();
                        this.writeJsonForArchivedJob(resp.getWriter(), archivedJob);
                    } else {
                        LOG.warn("DoGet:job: Could not find job for job ID " + jobId);
                    }
                } else if ("groupvertex".equals(req.getParameter("get"))) {
                    String jobId = req.getParameter("job");
                    String groupVertexId = req.getParameter("groupvertex");
                    if (groupVertexId.equals("null")) {
                        return;
                    }
                    Future response = Patterns.ask((ActorRef)this.archive, (Object)new JobManagerMessages.RequestJob(JobID.fromHexString((String)jobId)), (Timeout)new Timeout(this.timeout));
                    Object result = Await.result((Awaitable)response, (Duration)this.timeout);
                    if (!(result instanceof JobManagerMessages.JobResponse)) {
                        throw new RuntimeException("RequestJob requires a response of type JobResponse. Instead the response is of type " + result.getClass());
                    }
                    JobManagerMessages.JobResponse jobResponse = (JobManagerMessages.JobResponse)result;
                    if (jobResponse instanceof JobManagerMessages.JobFound && groupVertexId != null) {
                        ExecutionGraph archivedJob = ((JobManagerMessages.JobFound)jobResponse).executionGraph();
                        this.writeJsonForArchivedJobGroupvertex(resp.getWriter(), archivedJob, JobVertexID.fromHexString(groupVertexId));
                    } else {
                        LOG.warn("DoGet:groupvertex: Could not find job for job ID " + jobId);
                    }
                } else if ("taskmanagers".equals(req.getParameter("get"))) {
                    Future response = Patterns.ask((ActorRef)this.jobmanager, (Object)JobManagerMessages.getRequestNumberRegisteredTaskManager(), (Timeout)new Timeout(this.timeout));
                    Object result = Await.result((Awaitable)response, (Duration)this.timeout);
                    if (!(result instanceof Integer)) {
                        throw new RuntimeException("RequestNumberRegisteredTaskManager requires a response of type Integer. Instead the response is of type " + result.getClass() + ".");
                    }
                    int numberOfTaskManagers = (Integer)result;
                    Future responseRegisteredSlots = Patterns.ask((ActorRef)this.jobmanager, (Object)JobManagerMessages.getRequestTotalNumberOfSlots(), (Timeout)new Timeout(this.timeout));
                    Object resultRegisteredSlots = Await.result((Awaitable)responseRegisteredSlots, (Duration)this.timeout);
                    if (!(resultRegisteredSlots instanceof Integer)) {
                        throw new RuntimeException("RequestTotalNumberOfSlots requires a response of type Integer. Instaed the response of type " + resultRegisteredSlots.getClass() + ".");
                    }
                    int numberOfRegisteredSlots = (Integer)resultRegisteredSlots;
                    resp.getWriter().write("{\"taskmanagers\": " + numberOfTaskManagers + ", " + "\"slots\": " + numberOfRegisteredSlots + "}");
                } else if ("cancel".equals(req.getParameter("get"))) {
                    String jobId = req.getParameter("job");
                    Future response = Patterns.ask((ActorRef)this.jobmanager, (Object)new JobManagerMessages.CancelJob(JobID.fromHexString((String)jobId)), (Timeout)new Timeout(this.timeout));
                    Await.ready((Awaitable)response, (Duration)this.timeout);
                } else if ("updates".equals(req.getParameter("get"))) {
                    String jobId = req.getParameter("job");
                    this.writeJsonUpdatesForJob(resp.getWriter(), JobID.fromHexString((String)jobId));
                } else if ("version".equals(req.getParameter("get"))) {
                    this.writeJsonForVersion(resp.getWriter());
                } else {
                    Future response = Patterns.ask((ActorRef)this.jobmanager, (Object)JobManagerMessages.getRequestRunningJobs(), (Timeout)new Timeout(this.timeout));
                    Object result = Await.result((Awaitable)response, (Duration)this.timeout);
                    if (!(result instanceof JobManagerMessages.RunningJobs)) {
                        throw new RuntimeException("RequestRunningJobs requires a response of type RunningJobs. Instead the response of type " + result.getClass() + ".");
                    }
                    Iterable<ExecutionGraph> runningJobs = ((JobManagerMessages.RunningJobs)result).asJavaIterable();
                    this.writeJsonForJobs(resp.getWriter(), runningJobs);
                }
            }
            catch (Exception e) {
                resp.setStatus(400);
                resp.getWriter().print(e.getMessage());
                if (!LOG.isWarnEnabled()) break block30;
                LOG.warn(StringUtils.stringifyException((Throwable)e));
            }
        }
    }

    private void writeJsonForJobs(PrintWriter wrt, Iterable<ExecutionGraph> graphs) {
        try {
            wrt.write("[");
            Iterator<ExecutionGraph> it = graphs.iterator();
            while (it.hasNext()) {
                ExecutionGraph graph = it.next();
                this.writeJsonForJob(wrt, graph);
                if (!it.hasNext()) continue;
                wrt.write(",");
            }
            wrt.write("]");
        }
        catch (EofException eof) {
            LOG.info("Info server for jobmanager: Connection closed by client, EofException");
        }
        catch (IOException ioe) {
            LOG.info("Info server for jobmanager: Connection closed by client, IOException");
        }
    }

    private void writeJsonForJob(PrintWriter wrt, ExecutionGraph graph) throws IOException {
        wrt.write("{");
        wrt.write("\"jobid\": \"" + graph.getJobID() + "\",");
        wrt.write("\"jobname\": \"" + graph.getJobName() + "\",");
        wrt.write("\"status\": \"" + (Object)((Object)graph.getState()) + "\",");
        wrt.write("\"time\": " + graph.getStatusTimestamp(graph.getState()) + ",");
        wrt.write("\"groupvertices\": [");
        boolean first = true;
        for (ExecutionJobVertex groupVertex : graph.getVerticesTopologically()) {
            if (first) {
                first = false;
            } else {
                wrt.write(",");
            }
            wrt.write(JsonFactory.toJson(groupVertex));
        }
        wrt.write("]");
        wrt.write("}");
    }

    private void writeJsonForArchive(PrintWriter wrt, List<ExecutionGraph> graphs) {
        wrt.write("[");
        Collections.sort(graphs, new Comparator<ExecutionGraph>(){

            @Override
            public int compare(ExecutionGraph o1, ExecutionGraph o2) {
                if (o1.getStatusTimestamp(o1.getState()) < o2.getStatusTimestamp(o2.getState())) {
                    return 1;
                }
                return -1;
            }
        });
        for (int i = 0; i < graphs.size(); ++i) {
            ExecutionGraph graph = graphs.get(i);
            wrt.write("{");
            wrt.write("\"jobid\": \"" + graph.getJobID() + "\",");
            wrt.write("\"jobname\": \"" + graph.getJobName() + "\",");
            wrt.write("\"status\": \"" + (Object)((Object)graph.getState()) + "\",");
            wrt.write("\"time\": " + graph.getStatusTimestamp(graph.getState()));
            wrt.write("}");
            if (i == graphs.size() - 1) continue;
            wrt.write(",");
        }
        wrt.write("]");
    }

    private void writeJsonForJobCounts(PrintWriter wrt, Tuple3<Integer, Integer, Integer> jobCounts) {
        wrt.write("{");
        wrt.write("\"finished\": " + jobCounts._1() + ",");
        wrt.write("\"canceled\": " + jobCounts._2() + ",");
        wrt.write("\"failed\": " + jobCounts._3());
        wrt.write("}");
    }

    private void writeJsonForArchivedJob(PrintWriter wrt, ExecutionGraph graph) {
        try {
            Object result;
            int i;
            boolean first;
            wrt.write("[");
            wrt.write("{");
            wrt.write("\"jobid\": \"" + graph.getJobID() + "\",");
            wrt.write("\"jobname\": \"" + graph.getJobName() + "\",");
            wrt.write("\"status\": \"" + (Object)((Object)graph.getState()) + "\",");
            wrt.write("\"SCHEDULED\": " + graph.getStatusTimestamp(JobStatus.CREATED) + ",");
            wrt.write("\"RUNNING\": " + graph.getStatusTimestamp(JobStatus.RUNNING) + ",");
            wrt.write("\"FINISHED\": " + graph.getStatusTimestamp(JobStatus.FINISHED) + ",");
            wrt.write("\"FAILED\": " + graph.getStatusTimestamp(JobStatus.FAILED) + ",");
            wrt.write("\"CANCELED\": " + graph.getStatusTimestamp(JobStatus.CANCELED) + ",");
            if (graph.getState() == JobStatus.FAILED) {
                wrt.write("\"failednodes\": [");
                first = true;
                for (ExecutionVertex vertex : graph.getAllExecutionVertices()) {
                    if (vertex.getExecutionState() != ExecutionState.FAILED) continue;
                    InstanceConnectionInfo location = vertex.getCurrentAssignedResourceLocation();
                    Throwable failureCause = vertex.getFailureCause();
                    if (location == null && failureCause == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        wrt.write(",");
                    }
                    wrt.write("{");
                    wrt.write("\"node\": \"" + (location == null ? "(none)" : location.getFQDNHostname()) + "\",");
                    wrt.write("\"message\": \"" + (failureCause == null ? "" : StringUtils.escapeHtml((String)ExceptionUtils.stringifyException((Throwable)failureCause))) + "\"");
                    wrt.write("}");
                }
                wrt.write("],");
            }
            wrt.write("\"groupvertices\": [");
            first = true;
            for (ExecutionJobVertex groupVertex : graph.getVerticesTopologically()) {
                if (first) {
                    first = false;
                } else {
                    wrt.write(",");
                }
                wrt.write(JsonFactory.toJson(groupVertex));
            }
            wrt.write("],");
            ExecutionConfig ec = graph.getExecutionConfig();
            if (ec != null) {
                wrt.write("\"executionConfig\": {");
                wrt.write("\"Execution Mode\": \"" + ec.getExecutionMode() + "\",");
                wrt.write("\"Number of execution retries\": \"" + ec.getNumberOfExecutionRetries() + "\",");
                wrt.write("\"Job parallelism\": \"" + ec.getParallelism() + "\",");
                wrt.write("\"Object reuse mode\": \"" + ec.isObjectReuseEnabled() + "\"");
                ExecutionConfig.GlobalJobParameters uc = ec.getGlobalJobParameters();
                if (uc != null) {
                    Map ucVals = uc.toMap();
                    if (ucVals != null) {
                        String ucString = "{";
                        i = 0;
                        for (Map.Entry entry : ucVals.entrySet()) {
                            ucString = ucString + "\"" + (String)entry.getKey() + "\":\"" + (String)entry.getValue() + "\"";
                            if (++i >= ucVals.size()) continue;
                            ucString = ucString + ",\n";
                        }
                        wrt.write(", \"userConfig\": " + ucString + "}");
                    } else {
                        LOG.debug("GlobalJobParameters.toMap() did not return anything");
                    }
                } else {
                    LOG.debug("No GlobalJobParameters were set in the execution config");
                }
                wrt.write("},");
            } else {
                LOG.warn("Unable to retrieve execution config from execution graph");
            }
            Future response = Patterns.ask((ActorRef)this.jobmanager, (Object)new RequestAccumulatorResultsStringified(graph.getJobID()), (Timeout)new Timeout(this.timeout));
            try {
                result = Await.result((Awaitable)response, (Duration)this.timeout);
            }
            catch (Exception ex) {
                throw new IOException("Could not retrieve the accumulator results from the job manager.", ex);
            }
            if (result instanceof AccumulatorResultStringsFound) {
                StringifiedAccumulatorResult[] accumulators = ((AccumulatorResultStringsFound)result).result();
                wrt.write("\n\"accumulators\": [");
                i = 0;
                for (StringifiedAccumulatorResult accumulator : accumulators) {
                    wrt.write("{ \"name\": \"" + accumulator.getName() + " (" + accumulator.getType() + ")\"," + " \"value\": \"" + accumulator.getValue() + "\"}\n");
                    if (++i >= accumulators.length) continue;
                    wrt.write(",");
                }
                wrt.write("],\n");
            } else if (result instanceof AccumulatorResultsNotFound) {
                wrt.write("\n\"accumulators\": [],");
            } else if (result instanceof AccumulatorResultsErroneous) {
                LOG.error("Could not obtain accumulators for job " + graph.getJobID(), (Throwable)((AccumulatorResultsErroneous)result).cause());
            } else {
                throw new RuntimeException("RequestAccumulatorResults requires a response of type AccumulatorResultStringsFound. Instead the response is of type " + result.getClass() + ".");
            }
            wrt.write("\"groupverticetimes\": {");
            first = true;
            for (ExecutionJobVertex groupVertex : graph.getVerticesTopologically()) {
                if (first) {
                    first = false;
                } else {
                    wrt.write(",");
                }
                long started = Long.MAX_VALUE;
                long ended = 0L;
                for (ExecutionVertex vertex : groupVertex.getTaskVertices()) {
                    long running = vertex.getStateTimestamp(ExecutionState.RUNNING);
                    if (running != 0L && running < started) {
                        started = running;
                    }
                    long finished = vertex.getStateTimestamp(ExecutionState.FINISHED);
                    long canceled = vertex.getStateTimestamp(ExecutionState.CANCELED);
                    long failed = vertex.getStateTimestamp(ExecutionState.FAILED);
                    if (finished != 0L && finished > ended) {
                        ended = finished;
                    }
                    if (canceled != 0L && canceled > ended) {
                        ended = canceled;
                    }
                    if (failed == 0L || failed <= ended) continue;
                    ended = failed;
                }
                wrt.write("\"" + (Object)((Object)groupVertex.getJobVertexId()) + "\": {");
                wrt.write("\"groupvertexid\": \"" + (Object)((Object)groupVertex.getJobVertexId()) + "\",");
                wrt.write("\"groupvertexname\": \"" + groupVertex + "\",");
                wrt.write("\"STARTED\": " + started + ",");
                wrt.write("\"ENDED\": " + ended);
                wrt.write("}");
            }
            wrt.write("}");
            wrt.write("}");
            wrt.write("]");
        }
        catch (Exception ex) {
            LOG.error("Info server for JobManager: Failed to write json for archived jobs", (Throwable)ex);
        }
    }

    private void writeJsonUpdatesForJob(PrintWriter wrt, JobID jobId) {
        try {
            Future responseArchivedJobs = Patterns.ask((ActorRef)this.jobmanager, (Object)JobManagerMessages.getRequestRunningJobs(), (Timeout)new Timeout(this.timeout));
            Object resultArchivedJobs = null;
            try {
                resultArchivedJobs = Await.result((Awaitable)responseArchivedJobs, (Duration)this.timeout);
            }
            catch (Exception ex) {
                throw new IOException("Could not retrieve archived jobs from the job manager.", ex);
            }
            if (!(resultArchivedJobs instanceof JobManagerMessages.RunningJobs)) {
                throw new RuntimeException("RequestArchivedJobs requires a response of type RunningJobs. Instead the response is of type " + resultArchivedJobs.getClass() + ".");
            }
            Iterable<ExecutionGraph> graphs = ((JobManagerMessages.RunningJobs)resultArchivedJobs).asJavaIterable();
            wrt.write("{");
            wrt.write("\"jobid\": \"" + jobId + "\",");
            wrt.write("\"timestamp\": \"" + System.currentTimeMillis() + "\",");
            wrt.write("\"recentjobs\": [");
            boolean first = true;
            for (ExecutionGraph g : graphs) {
                if (first) {
                    first = false;
                } else {
                    wrt.write(",");
                }
                wrt.write("\"" + g.getJobID() + "\"");
            }
            wrt.write("],");
            Future responseJob = Patterns.ask((ActorRef)this.jobmanager, (Object)new JobManagerMessages.RequestJob(jobId), (Timeout)new Timeout(this.timeout));
            Object resultJob = null;
            try {
                resultJob = Await.result((Awaitable)responseJob, (Duration)this.timeout);
            }
            catch (Exception ex) {
                throw new IOException("Could not retrieve the job with jobID " + jobId + "from the job manager.", ex);
            }
            if (!(resultJob instanceof JobManagerMessages.JobResponse)) {
                throw new RuntimeException("RequestJob requires a response of type JobResponse. Instead the response is of type " + resultJob.getClass() + ".");
            }
            JobManagerMessages.JobResponse response = (JobManagerMessages.JobResponse)resultJob;
            if (response instanceof JobManagerMessages.JobFound) {
                ExecutionGraph graph = ((JobManagerMessages.JobFound)response).executionGraph();
                wrt.write("\"vertexevents\": [");
                first = true;
                for (ExecutionVertex ev : graph.getAllExecutionVertices()) {
                    if (first) {
                        first = false;
                    } else {
                        wrt.write(",");
                    }
                    wrt.write("{");
                    wrt.write("\"vertexid\": \"" + (Object)((Object)ev.getCurrentExecutionAttempt().getAttemptId()) + "\",");
                    wrt.write("\"newstate\": \"" + (Object)((Object)ev.getExecutionState()) + "\",");
                    wrt.write("\"timestamp\": \"" + ev.getStateTimestamp(ev.getExecutionState()) + "\"");
                    wrt.write("}");
                }
                wrt.write("],");
                wrt.write("\"jobevents\": [");
                wrt.write("{");
                wrt.write("\"newstate\": \"" + (Object)((Object)graph.getState()) + "\",");
                wrt.write("\"timestamp\": \"" + graph.getStatusTimestamp(graph.getState()) + "\"");
                wrt.write("}");
                wrt.write("]");
                wrt.write("}");
            } else {
                wrt.write("\"vertexevents\": [],");
                wrt.write("\"jobevents\": [");
                wrt.write("{");
                wrt.write("\"newstate\": \"" + (Object)((Object)JobStatus.FINISHED) + "\",");
                wrt.write("\"timestamp\": \"" + System.currentTimeMillis() + "\"");
                wrt.write("}");
                wrt.write("]");
                wrt.write("}");
                LOG.warn("WriteJsonUpdatesForJob: Could not find job with job ID " + jobId);
            }
        }
        catch (Exception exception) {
            LOG.info("Info server for jobmanager: Failed to write json updates for job {}, because {}.", (Object)jobId, (Object)StringUtils.stringifyException((Throwable)exception));
        }
    }

    private void writeJsonForArchivedJobGroupvertex(PrintWriter wrt, ExecutionGraph graph, JobVertexID vertexId) {
        ExecutionJobVertex jobVertex = graph.getJobVertex(vertexId);
        wrt.write("{\"groupvertex\": " + JsonFactory.toJson(jobVertex) + ",");
        wrt.write("\"verticetimes\": {");
        boolean first = true;
        for (ExecutionJobVertex groupVertex : graph.getAllVertices().values()) {
            for (ExecutionVertex vertex : groupVertex.getTaskVertices()) {
                Execution exec = vertex.getCurrentExecutionAttempt();
                if (first) {
                    first = false;
                } else {
                    wrt.write(",");
                }
                wrt.write("\"" + (Object)((Object)exec.getAttemptId()) + "\": {");
                wrt.write("\"vertexid\": \"" + (Object)((Object)exec.getAttemptId()) + "\",");
                wrt.write("\"vertexname\": \"" + vertex + "\",");
                wrt.write("\"CREATED\": " + vertex.getStateTimestamp(ExecutionState.CREATED) + ",");
                wrt.write("\"SCHEDULED\": " + vertex.getStateTimestamp(ExecutionState.SCHEDULED) + ",");
                wrt.write("\"DEPLOYING\": " + vertex.getStateTimestamp(ExecutionState.DEPLOYING) + ",");
                wrt.write("\"RUNNING\": " + vertex.getStateTimestamp(ExecutionState.RUNNING) + ",");
                wrt.write("\"FINISHED\": " + vertex.getStateTimestamp(ExecutionState.FINISHED) + ",");
                wrt.write("\"CANCELING\": " + vertex.getStateTimestamp(ExecutionState.CANCELING) + ",");
                wrt.write("\"CANCELED\": " + vertex.getStateTimestamp(ExecutionState.CANCELED) + ",");
                wrt.write("\"FAILED\": " + vertex.getStateTimestamp(ExecutionState.FAILED) + "");
                wrt.write("}");
            }
        }
        wrt.write("}}");
    }

    private void writeJsonForVersion(PrintWriter wrt) {
        wrt.write("{");
        wrt.write("\"version\": \"" + EnvironmentInformation.getVersion() + "\",");
        wrt.write("\"revision\": \"" + EnvironmentInformation.getRevisionInformation().commitId + "\"");
        wrt.write("}");
    }
}

