/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogfileInfoServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LogfileInfoServlet.class);
    private File[] logDirs;

    public LogfileInfoServlet(File[] logDirs) {
        if (logDirs == null) {
            throw new NullPointerException("The given log files are null.");
        }
        this.logDirs = logDirs;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block4: {
            try {
                if ("stdout".equals(req.getParameter("get"))) {
                    this.sendFile(".*jobmanager-[^\\.]*\\.out", resp);
                } else {
                    this.sendFile(".*jobmanager-[^\\.]*\\.log", resp);
                }
            }
            catch (Throwable t) {
                resp.setStatus(400);
                resp.getWriter().print("Error opening log files':" + t.getMessage());
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn(StringUtils.stringifyException((Throwable)t));
            }
        }
    }

    private void sendFile(String fileNamePattern, HttpServletResponse resp) throws IOException {
        for (File logDir : this.logDirs) {
            if (logDir == null) continue;
            File[] files = logDir.listFiles();
            if (files == null) {
                resp.setStatus(200);
                resp.setContentType("text/plain");
                resp.getOutputStream().write(("The specified log directory '" + logDir + "' is empty").getBytes());
                continue;
            }
            for (File f : files) {
                if (!f.getName().matches(fileNamePattern)) continue;
                resp.setStatus(200);
                resp.setContentType("text/plain");
                LogfileInfoServlet.writeFile((OutputStream)resp.getOutputStream(), f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(OutputStream out, File file) throws IOException {
        byte[] buf = new byte[4096];
        FileInputStream is = null;
        try {
            int bytesRead;
            is = new FileInputStream(file);
            out.write(("==== FILE: " + file.toString() + " ====\n").getBytes());
            while ((bytesRead = is.read(buf)) != -1) {
                out.write(buf, 0, bytesRead);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

