/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.web;

import akka.actor.ActorRef;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.servlet.Servlet;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.jobmanager.web.JobManagerInfoServlet;
import org.apache.flink.runtime.jobmanager.web.LogfileInfoServlet;
import org.apache.flink.runtime.jobmanager.web.MenuServlet;
import org.apache.flink.runtime.jobmanager.web.SetupInfoServlet;
import org.eclipse.jetty.http.security.Constraint;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.FiniteDuration;

public class WebInfoServer {
    private static final String WEB_ROOT_DIR = "web-docs-infoserver";
    private static final Logger LOG = LoggerFactory.getLogger(WebInfoServer.class);
    private final Server server;
    private int assignedPort;

    public WebInfoServer(Configuration config, ActorRef jobmanager, ActorRef archive) throws IOException {
        if (config == null) {
            throw new IllegalArgumentException("No Configuration has been passed to the web server");
        }
        if (jobmanager == null || archive == null) {
            throw new NullPointerException();
        }
        int port = config.getInteger("jobmanager.web.port", 8081);
        if (port < 0) {
            throw new IllegalArgumentException("Invalid port for the webserver: " + port);
        }
        FiniteDuration timeout = AkkaUtils.getTimeout(config);
        String basePath = config.getString("flink.base.dir.path", "");
        String[] logDirPaths = config.getString("jobmanager.web.logpath", basePath + "/log").split(",");
        URL webRootDir = this.getClass().getClassLoader().getResource(WEB_ROOT_DIR);
        if (webRootDir == null) {
            throw new FileNotFoundException("Cannot start JobManager web info server. The resource web-docs-infoserver is not included in the jar.");
        }
        File[] logDirFiles = new File[logDirPaths.length];
        int i = 0;
        for (String path : logDirPaths) {
            logDirFiles[i++] = new File(path);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Setting up web info server, using web-root directory " + webRootDir.toExternalForm() + ".");
        }
        this.server = new Server(port);
        ServletContextHandler servletContext = new ServletContextHandler(1);
        servletContext.setContextPath("/");
        servletContext.addServlet(new ServletHolder((Servlet)new JobManagerInfoServlet(jobmanager, archive, timeout)), "/jobsInfo");
        servletContext.addServlet(new ServletHolder((Servlet)new LogfileInfoServlet(logDirFiles)), "/logInfo");
        servletContext.addServlet(new ServletHolder((Servlet)new SetupInfoServlet(config, jobmanager, timeout)), "/setupInfo");
        servletContext.addServlet(new ServletHolder((Servlet)new MenuServlet()), "/menu");
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setDirectoriesListed(false);
        resourceHandler.setResourceBase(webRootDir.toExternalForm());
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)servletContext);
        handlers.addHandler((Handler)resourceHandler);
        File af = null;
        String authFile = config.getString("jobmanager.web.access", null);
        if (authFile != null && !(af = new File(authFile)).exists()) {
            LOG.error("The specified file '" + af.getAbsolutePath() + "' with the authentication information is missing. Starting server without HTTP authentication.");
            af = null;
        }
        if (af != null) {
            HashLoginService loginService = new HashLoginService("Flink Jobmanager Interface", authFile);
            this.server.addBean((Object)loginService);
            Constraint constraint = new Constraint();
            constraint.setName("BASIC");
            constraint.setAuthenticate(true);
            constraint.setRoles(new String[]{"user"});
            ConstraintMapping mapping = new ConstraintMapping();
            mapping.setPathSpec("/*");
            mapping.setConstraint(constraint);
            ConstraintSecurityHandler sh = new ConstraintSecurityHandler();
            sh.addConstraintMapping(mapping);
            sh.setAuthenticator((Authenticator)new BasicAuthenticator());
            sh.setLoginService((LoginService)loginService);
            sh.setStrict(true);
            sh.setHandler((Handler)handlers);
            this.server.setHandler((Handler)sh);
        } else {
            this.server.setHandler((Handler)handlers);
        }
    }

    public void start() throws Exception {
        this.server.start();
        Connector connector = this.server.getConnectors()[0];
        this.assignedPort = connector.getLocalPort();
        String host = connector.getHost();
        if (host == null) {
            host = "0.0.0.0";
        }
        LOG.info("Started web info server for JobManager on {}:{}", (Object)host, (Object)this.assignedPort);
    }

    public void stop() throws Exception {
        this.server.stop();
        this.assignedPort = 0;
    }

    public int getServerPort() {
        return this.assignedPort;
    }
}

