/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.runtime.state.StateHandle;

public abstract class ByteStreamStateHandle
implements StateHandle<Serializable> {
    private static final long serialVersionUID = -962025800339325828L;
    private transient Serializable state;

    public ByteStreamStateHandle(Serializable state) {
        this.state = state;
    }

    protected abstract OutputStream getOutputStream() throws Exception;

    protected abstract InputStream getInputStream() throws Exception;

    @Override
    public Serializable getState() throws Exception {
        if (!this.stateFetched()) {
            ObjectInputStream stream = new ObjectInputStream(this.getInputStream());
            this.state = (Serializable)stream.readObject();
            stream.close();
        }
        return this.state;
    }

    private void writeObject(ObjectOutputStream oos) throws Exception {
        ObjectOutputStream stream = new ObjectOutputStream(this.getOutputStream());
        stream.writeObject(this.state);
        stream.close();
        oos.defaultWriteObject();
    }

    public boolean stateFetched() {
        return this.state != null;
    }
}

