/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import akka.actor.ActorRef;
import akka.pattern.Patterns;
import akka.util.Timeout;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.util.InstantiationUtil;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public class TaskInputSplitProvider
implements InputSplitProvider {
    private final ActorRef jobManager;
    private final JobID jobId;
    private final JobVertexID vertexId;
    private final ExecutionAttemptID executionID;
    private final ClassLoader usercodeClassLoader;
    private final Timeout timeout;

    public TaskInputSplitProvider(ActorRef jobManager, JobID jobId, JobVertexID vertexId, ExecutionAttemptID executionID, ClassLoader userCodeClassLoader, Timeout timeout) {
        this.jobManager = jobManager;
        this.jobId = jobId;
        this.vertexId = vertexId;
        this.executionID = executionID;
        this.usercodeClassLoader = userCodeClassLoader;
        this.timeout = timeout;
    }

    @Override
    public InputSplit getNextInputSplit() {
        try {
            Future response = Patterns.ask((ActorRef)this.jobManager, (Object)new JobManagerMessages.RequestNextInputSplit(this.jobId, this.vertexId, this.executionID), (Timeout)this.timeout);
            Object result = Await.result((Awaitable)response, (Duration)this.timeout.duration());
            if (!(result instanceof JobManagerMessages.NextInputSplit)) {
                throw new RuntimeException("RequestNextInputSplit requires a response of type NextInputSplit. Instead response is of type " + result.getClass() + ".");
            }
            JobManagerMessages.NextInputSplit nextInputSplit = (JobManagerMessages.NextInputSplit)result;
            byte[] serializedData = nextInputSplit.splitData();
            if (serializedData == null) {
                return null;
            }
            Object deserialized = InstantiationUtil.deserializeObject((byte[])serializedData, (ClassLoader)this.usercodeClassLoader);
            return (InputSplit)deserialized;
        }
        catch (Exception e) {
            throw new RuntimeException("Requesting the next InputSplit failed.", e);
        }
    }
}

