/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.collector.selector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.streaming.api.collector.selector.OutputSelector;
import org.apache.flink.streaming.api.collector.selector.OutputSelectorWrapper;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectedOutputSelectorWrapper<OUT>
implements OutputSelectorWrapper<OUT> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DirectedOutputSelectorWrapper.class);
    private List<OutputSelector<OUT>> outputSelectors;
    private HashMap<String, ArrayList<Collector<StreamRecord<OUT>>>> outputMap;
    private HashSet<Collector<StreamRecord<OUT>>> selectAllOutputs;

    public DirectedOutputSelectorWrapper(List<OutputSelector<OUT>> outputSelectors) {
        this.outputSelectors = outputSelectors;
        this.selectAllOutputs = new HashSet();
        this.outputMap = new HashMap();
    }

    @Override
    public void addCollector(Collector<StreamRecord<OUT>> output, StreamEdge edge) {
        List<String> selectedNames = edge.getSelectedNames();
        if (selectedNames.isEmpty()) {
            this.selectAllOutputs.add(output);
        } else {
            for (String selectedName : selectedNames) {
                if (!this.outputMap.containsKey(selectedName)) {
                    this.outputMap.put(selectedName, new ArrayList());
                    this.outputMap.get(selectedName).add(output);
                    continue;
                }
                if (this.outputMap.get(selectedName).contains(output)) continue;
                this.outputMap.get(selectedName).add(output);
            }
        }
    }

    @Override
    public Iterable<Collector<StreamRecord<OUT>>> getSelectedOutputs(OUT record) {
        HashSet<Collector<StreamRecord<OUT>>> selectedOutputs = new HashSet<Collector<StreamRecord<OUT>>>(this.selectAllOutputs);
        for (OutputSelector<OUT> outputSelector : this.outputSelectors) {
            Iterable<String> outputNames = outputSelector.select(record);
            for (String outputName : outputNames) {
                List outputList = this.outputMap.get(outputName);
                try {
                    selectedOutputs.addAll(outputList);
                }
                catch (NullPointerException e) {
                    if (!LOG.isErrorEnabled()) continue;
                    String format = String.format("Cannot emit because no output is selected with the name: %s", outputName);
                    LOG.error(format);
                }
            }
        }
        return selectedOutputs;
    }
}

