/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.api.common.functions.FoldFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.aggregation.AggregationFunction;
import org.apache.flink.streaming.api.functions.aggregation.ComparableAggregator;
import org.apache.flink.streaming.api.functions.aggregation.SumAggregator;
import org.apache.flink.streaming.api.functions.windowing.FoldWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.ReduceWindowFunction;
import org.apache.flink.streaming.api.functions.windowing.WindowFunction;
import org.apache.flink.streaming.api.windowing.assigners.SlidingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.TumblingTimeWindows;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.triggers.ProcessingTimeTrigger;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.AccumulatingProcessingTimeWindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.AggregatingProcessingTimeWindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.EvictingWindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.WindowOperator;
import org.apache.flink.streaming.runtime.operators.windowing.buffers.HeapWindowBuffer;
import org.apache.flink.streaming.runtime.operators.windowing.buffers.PreAggregatingHeapWindowBuffer;

public class WindowedStream<T, K, W extends Window> {
    private final KeyedStream<T, K> input;
    private final WindowAssigner<? super T, W> windowAssigner;
    private Trigger<? super T, ? super W> trigger;
    private Evictor<? super T, ? super W> evictor;

    public WindowedStream(KeyedStream<T, K> input, WindowAssigner<? super T, W> windowAssigner) {
        this.input = input;
        this.windowAssigner = windowAssigner;
        this.trigger = windowAssigner.getDefaultTrigger(input.getExecutionEnvironment());
    }

    public WindowedStream<T, K, W> trigger(Trigger<? super T, ? super W> trigger) {
        this.trigger = trigger;
        return this;
    }

    public WindowedStream<T, K, W> evictor(Evictor<? super T, ? super W> evictor) {
        this.evictor = evictor;
        return this;
    }

    public SingleOutputStreamOperator<T, ?> reduce(ReduceFunction<T> function) {
        function = this.input.getExecutionEnvironment().clean(function);
        String callLocation = Utils.getCallLocationName();
        String udfName = "Reduce at " + callLocation;
        SingleOutputStreamOperator result = this.createFastTimeOperatorIfValid((Function)function, (TypeInformation)this.input.getType(), udfName);
        if (result != null) {
            return result;
        }
        String opName = "TriggerWindow(" + this.windowAssigner + ", " + this.trigger + ", " + udfName + ")";
        KeySelector<T, K> keySel = this.input.getKeySelector();
        boolean setProcessingTime = this.input.getExecutionEnvironment().getStreamTimeCharacteristic() == TimeCharacteristic.ProcessingTime;
        WindowOperator operator = this.evictor != null ? new EvictingWindowOperator(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), new HeapWindowBuffer.Factory(), new ReduceWindowFunction(function), this.trigger, this.evictor).enableSetProcessingTime(setProcessingTime) : new WindowOperator(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), new PreAggregatingHeapWindowBuffer.Factory<T>(function), new ReduceWindowFunction(function), this.trigger).enableSetProcessingTime(setProcessingTime);
        return this.input.transform(opName, this.input.getType(), operator);
    }

    public <R> SingleOutputStreamOperator<R, ?> fold(R initialValue, FoldFunction<T, R> function) {
        function = this.input.getExecutionEnvironment().clean(function);
        TypeInformation resultType = TypeExtractor.getFoldReturnTypes(function, this.input.getType(), (String)Utils.getCallLocationName(), (boolean)true);
        return this.apply(new FoldWindowFunction(initialValue, function), resultType);
    }

    public <R> SingleOutputStreamOperator<R, ?> fold(R initialValue, FoldFunction<T, R> function, TypeInformation<R> resultType) {
        function = this.input.getExecutionEnvironment().clean(function);
        return this.apply(new FoldWindowFunction(initialValue, function), resultType);
    }

    public <R> SingleOutputStreamOperator<R, ?> apply(WindowFunction<T, R, K, W> function) {
        TypeInformation inType = this.input.getType();
        TypeInformation resultType = TypeExtractor.getUnaryOperatorReturnType(function, WindowFunction.class, (boolean)true, (boolean)true, inType, null, (boolean)false);
        return this.apply(function, resultType);
    }

    public <R> SingleOutputStreamOperator<R, ?> apply(WindowFunction<T, R, K, W> function, TypeInformation<R> resultType) {
        function = this.input.getExecutionEnvironment().clean(function);
        String callLocation = Utils.getCallLocationName();
        String udfName = "WindowApply at " + callLocation;
        SingleOutputStreamOperator<R, ?> result = this.createFastTimeOperatorIfValid(function, resultType, udfName);
        if (result != null) {
            return result;
        }
        String opName = "TriggerWindow(" + this.windowAssigner + ", " + this.trigger + ", " + udfName + ")";
        KeySelector<T, K> keySel = this.input.getKeySelector();
        boolean setProcessingTime = this.input.getExecutionEnvironment().getStreamTimeCharacteristic() == TimeCharacteristic.ProcessingTime;
        WindowOperator operator = this.evictor != null ? new EvictingWindowOperator<K, T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), new HeapWindowBuffer.Factory(), function, this.trigger, this.evictor).enableSetProcessingTime(setProcessingTime) : new WindowOperator<K, T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), new HeapWindowBuffer.Factory(), function, this.trigger).enableSetProcessingTime(setProcessingTime);
        return this.input.transform(opName, resultType, operator);
    }

    public <R> SingleOutputStreamOperator<R, ?> apply(ReduceFunction<T> preAggregator, WindowFunction<T, R, K, W> function) {
        TypeInformation inType = this.input.getType();
        TypeInformation resultType = TypeExtractor.getUnaryOperatorReturnType(function, WindowFunction.class, (boolean)true, (boolean)true, inType, null, (boolean)false);
        return this.apply(preAggregator, function, resultType);
    }

    public <R> SingleOutputStreamOperator<R, ?> apply(ReduceFunction<T> preAggregator, WindowFunction<T, R, K, W> function, TypeInformation<R> resultType) {
        function = this.input.getExecutionEnvironment().clean(function);
        preAggregator = this.input.getExecutionEnvironment().clean(preAggregator);
        String callLocation = Utils.getCallLocationName();
        String udfName = "WindowApply at " + callLocation;
        String opName = "TriggerWindow(" + this.windowAssigner + ", " + this.trigger + ", " + udfName + ")";
        KeySelector<T, K> keySel = this.input.getKeySelector();
        boolean setProcessingTime = this.input.getExecutionEnvironment().getStreamTimeCharacteristic() == TimeCharacteristic.ProcessingTime;
        WindowOperator operator = this.evictor != null ? new EvictingWindowOperator<K, T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), new HeapWindowBuffer.Factory(), function, this.trigger, this.evictor).enableSetProcessingTime(setProcessingTime) : new WindowOperator<K, T, R, W>(this.windowAssigner, this.windowAssigner.getWindowSerializer(this.getExecutionEnvironment().getConfig()), keySel, this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), new PreAggregatingHeapWindowBuffer.Factory<T>(preAggregator), function, this.trigger).enableSetProcessingTime(setProcessingTime);
        return this.input.transform(opName, resultType, operator);
    }

    public SingleOutputStreamOperator<T, ?> sum(int positionToSum) {
        return this.aggregate(new SumAggregator(positionToSum, this.input.getType(), this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> sum(String field) {
        return this.aggregate(new SumAggregator(field, this.input.getType(), this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> min(int positionToMin) {
        return this.aggregate(new ComparableAggregator(positionToMin, this.input.getType(), AggregationFunction.AggregationType.MIN, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> min(String field) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MIN, false, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> minBy(int positionToMinBy) {
        return this.minBy(positionToMinBy, true);
    }

    public SingleOutputStreamOperator<T, ?> minBy(String positionToMinBy) {
        return this.minBy(positionToMinBy, true);
    }

    public SingleOutputStreamOperator<T, ?> minBy(int positionToMinBy, boolean first) {
        return this.aggregate(new ComparableAggregator(positionToMinBy, this.input.getType(), AggregationFunction.AggregationType.MINBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> minBy(String field, boolean first) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MINBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> max(int positionToMax) {
        return this.aggregate(new ComparableAggregator(positionToMax, this.input.getType(), AggregationFunction.AggregationType.MAX, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> max(String field) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MAX, false, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> maxBy(int positionToMaxBy) {
        return this.maxBy(positionToMaxBy, true);
    }

    public SingleOutputStreamOperator<T, ?> maxBy(String positionToMaxBy) {
        return this.maxBy(positionToMaxBy, true);
    }

    public SingleOutputStreamOperator<T, ?> maxBy(int positionToMaxBy, boolean first) {
        return this.aggregate(new ComparableAggregator(positionToMaxBy, this.input.getType(), AggregationFunction.AggregationType.MAXBY, first, this.input.getExecutionConfig()));
    }

    public SingleOutputStreamOperator<T, ?> maxBy(String field, boolean first) {
        return this.aggregate(new ComparableAggregator(field, this.input.getType(), AggregationFunction.AggregationType.MAXBY, first, this.input.getExecutionConfig()));
    }

    private SingleOutputStreamOperator<T, ?> aggregate(AggregationFunction<T> aggregator) {
        return this.reduce((ReduceFunction<T>)aggregator);
    }

    private <R> SingleOutputStreamOperator<R, ?> createFastTimeOperatorIfValid(Function function, TypeInformation<R> resultType, String functionName) {
        if (this.windowAssigner instanceof SlidingTimeWindows && this.trigger instanceof ProcessingTimeTrigger && this.evictor == null) {
            SlidingTimeWindows timeWindows = (SlidingTimeWindows)this.windowAssigner;
            long windowLength = timeWindows.getSize();
            long windowSlide = timeWindows.getSlide();
            String opName = "Fast " + timeWindows + " of " + functionName;
            if (function instanceof ReduceFunction) {
                ReduceFunction reducer = (ReduceFunction)function;
                AggregatingProcessingTimeWindowOperator<K, T> op = new AggregatingProcessingTimeWindowOperator<K, T>(reducer, this.input.getKeySelector(), this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()), windowLength, windowSlide);
                return this.input.transform(opName, resultType, op);
            }
            if (function instanceof WindowFunction) {
                WindowFunction wf = (WindowFunction)function;
                AccumulatingProcessingTimeWindowOperator op = new AccumulatingProcessingTimeWindowOperator(wf, this.input.getKeySelector(), this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()), windowLength, windowSlide);
                return this.input.transform(opName, resultType, op);
            }
        } else if (this.windowAssigner instanceof TumblingTimeWindows && this.trigger instanceof ProcessingTimeTrigger && this.evictor == null) {
            TumblingTimeWindows timeWindows = (TumblingTimeWindows)this.windowAssigner;
            long windowLength = timeWindows.getSize();
            long windowSlide = timeWindows.getSize();
            String opName = "Fast " + timeWindows + " of " + functionName;
            if (function instanceof ReduceFunction) {
                ReduceFunction reducer = (ReduceFunction)function;
                AggregatingProcessingTimeWindowOperator<K, T> op = new AggregatingProcessingTimeWindowOperator<K, T>(reducer, this.input.getKeySelector(), this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()), windowLength, windowSlide);
                return this.input.transform(opName, resultType, op);
            }
            if (function instanceof WindowFunction) {
                WindowFunction wf = (WindowFunction)function;
                AccumulatingProcessingTimeWindowOperator op = new AccumulatingProcessingTimeWindowOperator(wf, this.input.getKeySelector(), this.input.getKeyType().createSerializer(this.getExecutionEnvironment().getConfig()), this.input.getType().createSerializer(this.getExecutionEnvironment().getConfig()), windowLength, windowSlide);
                return this.input.transform(opName, resultType, op);
            }
        }
        return null;
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.input.getExecutionEnvironment();
    }

    public TypeInformation<T> getInputType() {
        return this.input.getType();
    }
}

