/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.net.URL;
import java.util.List;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.client.program.Client;
import org.apache.flink.client.program.JobWithJars;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamContextEnvironment
extends StreamExecutionEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(StreamContextEnvironment.class);
    private final List<URL> jars;
    private final List<URL> classpaths;
    private final Client client;
    private final ClassLoader userCodeClassLoader;
    private final boolean wait;

    protected StreamContextEnvironment(Client client, List<URL> jars, List<URL> classpaths, int parallelism, boolean wait) {
        this.client = client;
        this.jars = jars;
        this.classpaths = classpaths;
        this.wait = wait;
        this.userCodeClassLoader = JobWithJars.buildUserCodeClassLoader(jars, classpaths, (ClassLoader)this.getClass().getClassLoader());
        if (parallelism > 0) {
            this.setParallelism(parallelism);
        } else {
            this.setParallelism(GlobalConfiguration.getInteger((String)"parallelism.default", (int)1));
        }
    }

    @Override
    public JobExecutionResult execute() throws Exception {
        return this.execute(null);
    }

    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        JobGraph jobGraph = jobName == null ? this.getStreamGraph().getJobGraph() : this.getStreamGraph().getJobGraph(jobName);
        this.transformations.clear();
        for (URL file : this.jars) {
            jobGraph.addJar(new Path(file.toURI()));
        }
        jobGraph.setClasspaths(this.classpaths);
        if (this.wait) {
            return this.client.runBlocking(jobGraph, this.userCodeClassLoader);
        }
        JobSubmissionResult result = this.client.runDetached(jobGraph, this.userCodeClassLoader);
        LOG.warn("Job was executed in detached mode, the results will be available on completion.");
        return JobExecutionResult.fromJobSubmissionResult((JobSubmissionResult)result);
    }
}

