/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import com.esotericsoftware.kryo.Serializer;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.PrimitiveInputFormat;
import org.apache.flink.api.java.io.TextInputFormat;
import org.apache.flink.api.java.io.TextValueInputFormat;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.MissingTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.client.program.Client;
import org.apache.flink.client.program.ContextEnvironment;
import org.apache.flink.client.program.OptimizerPlanEnvironment;
import org.apache.flink.client.program.PreviewPlanEnvironment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.RemoteStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamContextEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironmentFactory;
import org.apache.flink.streaming.api.environment.StreamPlanEnvironment;
import org.apache.flink.streaming.api.functions.source.FileMonitoringFunction;
import org.apache.flink.streaming.api.functions.source.FileReadFunction;
import org.apache.flink.streaming.api.functions.source.FileSourceFunction;
import org.apache.flink.streaming.api.functions.source.FromElementsFunction;
import org.apache.flink.streaming.api.functions.source.FromIteratorFunction;
import org.apache.flink.streaming.api.functions.source.FromSplittableIteratorFunction;
import org.apache.flink.streaming.api.functions.source.ParallelSourceFunction;
import org.apache.flink.streaming.api.functions.source.SocketTextStreamFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.functions.source.StatefulSequenceSource;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.StreamGraphGenerator;
import org.apache.flink.streaming.api.operators.StreamSource;
import org.apache.flink.streaming.api.transformations.StreamTransformation;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.SplittableIterator;

public abstract class StreamExecutionEnvironment {
    public static final String DEFAULT_JOB_NAME = "Flink Streaming Job";
    private static final TimeCharacteristic DEFAULT_TIME_CHARACTERISTIC = TimeCharacteristic.ProcessingTime;
    private static final long DEFAULT_NETWORK_BUFFER_TIMEOUT = 100L;
    private static StreamExecutionEnvironmentFactory contextEnvironmentFactory;
    private static int defaultLocalParallelism;
    private final ExecutionConfig config = new ExecutionConfig();
    protected final List<StreamTransformation<?>> transformations = new ArrayList();
    private long bufferTimeout = 100L;
    protected boolean isChainingEnabled = true;
    protected long checkpointInterval = -1L;
    protected CheckpointingMode checkpointingMode;
    protected boolean forceCheckpointing = false;
    private StateBackend<?> defaultStateBackend;
    private TimeCharacteristic timeCharacteristic = DEFAULT_TIME_CHARACTERISTIC;

    public ExecutionConfig getConfig() {
        return this.config;
    }

    public StreamExecutionEnvironment setParallelism(int parallelism) {
        if (parallelism < 1) {
            throw new IllegalArgumentException("parallelism must be at least one.");
        }
        this.config.setParallelism(parallelism);
        return this;
    }

    public int getParallelism() {
        return this.config.getParallelism();
    }

    public StreamExecutionEnvironment setBufferTimeout(long timeoutMillis) {
        if (timeoutMillis < -1L) {
            throw new IllegalArgumentException("Timeout of buffer must be non-negative or -1");
        }
        this.bufferTimeout = timeoutMillis;
        return this;
    }

    public long getBufferTimeout() {
        return this.bufferTimeout;
    }

    public StreamExecutionEnvironment disableOperatorChaining() {
        this.isChainingEnabled = false;
        return this;
    }

    public boolean isChainingEnabled() {
        return this.isChainingEnabled;
    }

    public StreamExecutionEnvironment enableCheckpointing(long interval) {
        return this.enableCheckpointing(interval, CheckpointingMode.EXACTLY_ONCE);
    }

    public StreamExecutionEnvironment enableCheckpointing(long interval, CheckpointingMode mode) {
        if (mode == null) {
            throw new NullPointerException("checkpoint mode must not be null");
        }
        if (interval <= 0L) {
            throw new IllegalArgumentException("the checkpoint interval must be positive");
        }
        this.checkpointInterval = interval;
        this.checkpointingMode = mode;
        return this;
    }

    @Deprecated
    public StreamExecutionEnvironment enableCheckpointing(long interval, CheckpointingMode mode, boolean force) {
        this.enableCheckpointing(interval, mode);
        this.forceCheckpointing = force;
        return this;
    }

    public StreamExecutionEnvironment enableCheckpointing() {
        this.enableCheckpointing(500L, CheckpointingMode.EXACTLY_ONCE);
        return this;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public boolean isForceCheckpointing() {
        return this.forceCheckpointing;
    }

    public CheckpointingMode getCheckpointingMode() {
        return this.checkpointingMode;
    }

    public StreamExecutionEnvironment setStateBackend(StateBackend<?> backend) {
        this.defaultStateBackend = Objects.requireNonNull(backend);
        return this;
    }

    public StateBackend<?> getStateBackend() {
        return this.defaultStateBackend;
    }

    public void setNumberOfExecutionRetries(int numberOfExecutionRetries) {
        this.config.setNumberOfExecutionRetries(numberOfExecutionRetries);
    }

    public int getNumberOfExecutionRetries() {
        return this.config.getNumberOfExecutionRetries();
    }

    public static void setDefaultLocalParallelism(int parallelism) {
        defaultLocalParallelism = parallelism;
    }

    public <T extends Serializer<?>> void addDefaultKryoSerializer(Class<?> type, T serializer) {
        this.config.addDefaultKryoSerializer(type, serializer);
    }

    public void addDefaultKryoSerializer(Class<?> type, Class<? extends Serializer<?>> serializerClass) {
        this.config.addDefaultKryoSerializer(type, serializerClass);
    }

    public <T extends Serializer<?>> void registerTypeWithKryoSerializer(Class<?> type, T serializer) {
        this.config.registerTypeWithKryoSerializer(type, serializer);
    }

    public void registerTypeWithKryoSerializer(Class<?> type, Class<? extends Serializer<?>> serializerClass) {
        this.config.registerTypeWithKryoSerializer(type, serializerClass);
    }

    public void registerType(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Cannot register null type class.");
        }
        TypeInformation typeInfo = TypeExtractor.createTypeInfo(type);
        if (typeInfo instanceof PojoTypeInfo) {
            this.config.registerPojoType(type);
        } else {
            this.config.registerKryoType(type);
        }
    }

    public void setStreamTimeCharacteristic(TimeCharacteristic characteristic) {
        this.timeCharacteristic = Objects.requireNonNull(characteristic);
        if (characteristic == TimeCharacteristic.ProcessingTime) {
            this.getConfig().disableTimestamps();
            this.getConfig().setAutoWatermarkInterval(0L);
        } else {
            this.getConfig().enableTimestamps();
            this.getConfig().setAutoWatermarkInterval(200L);
        }
    }

    public TimeCharacteristic getStreamTimeCharacteristic() {
        return this.timeCharacteristic;
    }

    public DataStreamSource<Long> generateSequence(long from, long to) {
        if (from > to) {
            throw new IllegalArgumentException("Start of sequence must not be greater than the end");
        }
        return this.addSource(new StatefulSequenceSource(from, to), "Sequence Source");
    }

    @SafeVarargs
    public final <OUT> DataStreamSource<OUT> fromElements(OUT ... data) {
        TypeInformation typeInfo;
        if (data.length == 0) {
            throw new IllegalArgumentException("fromElements needs at least one element as argument");
        }
        try {
            typeInfo = TypeExtractor.getForObject(data[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create TypeInformation for type " + data[0].getClass().getName() + "; please specify the TypeInformation manually via " + "StreamExecutionEnvironment#fromElements(Collection, TypeInformation)");
        }
        return this.fromCollection(Arrays.asList(data), typeInfo);
    }

    public <OUT> DataStreamSource<OUT> fromCollection(Collection<OUT> data) {
        TypeInformation typeInfo;
        Preconditions.checkNotNull(data, "Collection must not be null");
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Collection must not be empty");
        }
        OUT first = data.iterator().next();
        if (first == null) {
            throw new IllegalArgumentException("Collection must not contain null elements");
        }
        try {
            typeInfo = TypeExtractor.getForObject(first);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create TypeInformation for type " + first.getClass() + "; please specify the TypeInformation manually via " + "StreamExecutionEnvironment#fromElements(Collection, TypeInformation)");
        }
        return this.fromCollection(data, typeInfo);
    }

    public <OUT> DataStreamSource<OUT> fromCollection(Collection<OUT> data, TypeInformation<OUT> typeInfo) {
        FromElementsFunction<OUT> function;
        Preconditions.checkNotNull(data, "Collection must not be null");
        FromElementsFunction.checkCollection(data, typeInfo.getTypeClass());
        try {
            function = new FromElementsFunction<OUT>(typeInfo.createSerializer(this.getConfig()), data);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.addSource(function, "Collection Source", typeInfo).setParallelism(1);
    }

    public <OUT> DataStreamSource<OUT> fromCollection(Iterator<OUT> data, Class<OUT> type) {
        return this.fromCollection(data, TypeExtractor.getForClass(type));
    }

    public <OUT> DataStreamSource<OUT> fromCollection(Iterator<OUT> data, TypeInformation<OUT> typeInfo) {
        Preconditions.checkNotNull(data, "The iterator must not be null");
        FromIteratorFunction<OUT> function = new FromIteratorFunction<OUT>(data);
        return this.addSource(function, "Collection Source", typeInfo);
    }

    public <OUT> DataStreamSource<OUT> fromParallelCollection(SplittableIterator<OUT> iterator, Class<OUT> type) {
        return this.fromParallelCollection(iterator, TypeExtractor.getForClass(type));
    }

    public <OUT> DataStreamSource<OUT> fromParallelCollection(SplittableIterator<OUT> iterator, TypeInformation<OUT> typeInfo) {
        return this.fromParallelCollection(iterator, typeInfo, "Parallel Collection Source");
    }

    private <OUT> DataStreamSource<OUT> fromParallelCollection(SplittableIterator<OUT> iterator, TypeInformation<OUT> typeInfo, String operatorName) {
        return (DataStreamSource)this.addSource(new FromSplittableIteratorFunction<OUT>(iterator), operatorName).returns(typeInfo);
    }

    public DataStreamSource<String> readTextFile(String filePath) {
        Preconditions.checkNotNull(filePath, "The file path may not be null.");
        TextInputFormat format = new TextInputFormat(new Path(filePath));
        BasicTypeInfo typeInfo = BasicTypeInfo.STRING_TYPE_INFO;
        return this.createInput((InputFormat)format, (TypeInformation)typeInfo, "Read Text File Source");
    }

    public DataStreamSource<String> readTextFile(String filePath, String charsetName) {
        Preconditions.checkNotNull(filePath, "The file path may not be null.");
        TextInputFormat format = new TextInputFormat(new Path(filePath));
        BasicTypeInfo typeInfo = BasicTypeInfo.STRING_TYPE_INFO;
        format.setCharsetName(charsetName);
        return this.createInput((InputFormat)format, (TypeInformation)typeInfo, "Read Text File Source");
    }

    public DataStreamSource<StringValue> readTextFileWithValue(String filePath) {
        Preconditions.checkNotNull(filePath, "The file path may not be null.");
        TextValueInputFormat format = new TextValueInputFormat(new Path(filePath));
        ValueTypeInfo typeInfo = new ValueTypeInfo(StringValue.class);
        return this.createInput((InputFormat)format, (TypeInformation)typeInfo, "Read Text File with Value source");
    }

    public DataStreamSource<StringValue> readTextFileWithValue(String filePath, String charsetName, boolean skipInvalidLines) {
        Preconditions.checkNotNull(filePath, "The file path may not be null.");
        TextValueInputFormat format = new TextValueInputFormat(new Path(filePath));
        ValueTypeInfo typeInfo = new ValueTypeInfo(StringValue.class);
        format.setCharsetName(charsetName);
        format.setSkipInvalidLines(skipInvalidLines);
        return this.createInput((InputFormat)format, (TypeInformation)typeInfo, "Read Text File with Value source");
    }

    public <OUT> DataStreamSource<OUT> readFile(FileInputFormat<OUT> inputFormat, String filePath) {
        Preconditions.checkNotNull(inputFormat, "InputFormat must not be null.");
        Preconditions.checkNotNull(filePath, "The file path must not be null.");
        inputFormat.setFilePath(new Path(filePath));
        try {
            return this.createInput((InputFormat<OUT, ?>)inputFormat, (TypeInformation<OUT>)TypeExtractor.getInputFormatTypes(inputFormat), "Read File source");
        }
        catch (Exception e) {
            throw new InvalidProgramException("The type returned by the input format could not be automatically determined. Please specify the TypeInformation of the produced type explicitly by using the 'createInput(InputFormat, TypeInformation)' method instead.");
        }
    }

    public <OUT> DataStreamSource<OUT> readFileOfPrimitives(String filePath, Class<OUT> typeClass) {
        Preconditions.checkNotNull(filePath, "The file path may not be null.");
        PrimitiveInputFormat inputFormat = new PrimitiveInputFormat(new Path(filePath), typeClass);
        TypeInformation typeInfo = TypeExtractor.getForClass(typeClass);
        return this.createInput((InputFormat<OUT, ?>)inputFormat, (TypeInformation<OUT>)typeInfo, "Read File of Primitives source");
    }

    public <OUT> DataStreamSource<OUT> readFileOfPrimitives(String filePath, String delimiter, Class<OUT> typeClass) {
        Preconditions.checkNotNull(filePath, "The file path may not be null.");
        PrimitiveInputFormat inputFormat = new PrimitiveInputFormat(new Path(filePath), delimiter, typeClass);
        TypeInformation typeInfo = TypeExtractor.getForClass(typeClass);
        return this.createInput((InputFormat<OUT, ?>)inputFormat, (TypeInformation<OUT>)typeInfo, "Read File of Primitives source");
    }

    public DataStream<String> readFileStream(String filePath, long intervalMillis, FileMonitoringFunction.WatchType watchType) {
        DataStreamSource<Tuple3<String, Long, Long>> source = this.addSource(new FileMonitoringFunction(filePath, intervalMillis, watchType), "Read File Stream source");
        return source.flatMap(new FileReadFunction());
    }

    public DataStreamSource<String> socketTextStream(String hostname, int port, char delimiter, long maxRetry) {
        return this.addSource(new SocketTextStreamFunction(hostname, port, delimiter, maxRetry), "Socket Stream");
    }

    public DataStreamSource<String> socketTextStream(String hostname, int port, char delimiter) {
        return this.socketTextStream(hostname, port, delimiter, 0L);
    }

    public DataStreamSource<String> socketTextStream(String hostname, int port) {
        return this.socketTextStream(hostname, port, '\n');
    }

    public <OUT> DataStreamSource<OUT> createInput(InputFormat<OUT, ?> inputFormat) {
        return this.createInput(inputFormat, TypeExtractor.getInputFormatTypes(inputFormat), "Custom File source");
    }

    public <OUT> DataStreamSource<OUT> createInput(InputFormat<OUT, ?> inputFormat, TypeInformation<OUT> typeInfo) {
        return this.createInput(inputFormat, typeInfo, "Custom File source");
    }

    private <OUT> DataStreamSource<OUT> createInput(InputFormat<OUT, ?> inputFormat, TypeInformation<OUT> typeInfo, String sourceName) {
        FileSourceFunction<OUT> function = new FileSourceFunction<OUT>(inputFormat, typeInfo);
        return (DataStreamSource)this.addSource(function, sourceName).returns(typeInfo);
    }

    public <OUT> DataStreamSource<OUT> addSource(SourceFunction<OUT> function) {
        return this.addSource(function, "Custom Source");
    }

    public <OUT> DataStreamSource<OUT> addSource(SourceFunction<OUT> function, String sourceName) {
        return this.addSource(function, sourceName, null);
    }

    public <OUT> DataStreamSource<OUT> addSource(SourceFunction<OUT> function, TypeInformation<OUT> typeInfo) {
        return this.addSource(function, "Custom Source", typeInfo);
    }

    public <OUT> DataStreamSource<OUT> addSource(SourceFunction<OUT> function, String sourceName, TypeInformation<OUT> typeInfo) {
        if (typeInfo == null) {
            if (function instanceof ResultTypeQueryable) {
                typeInfo = ((ResultTypeQueryable)function).getProducedType();
            } else {
                try {
                    typeInfo = TypeExtractor.createTypeInfo(SourceFunction.class, function.getClass(), (int)0, null, null);
                }
                catch (InvalidTypesException e) {
                    typeInfo = new MissingTypeInfo(sourceName, e);
                }
            }
        }
        boolean isParallel = function instanceof ParallelSourceFunction;
        this.clean(function);
        StreamSource<OUT> sourceOperator = new StreamSource<OUT>(function);
        return new DataStreamSource<OUT>(this, typeInfo, sourceOperator, isParallel, sourceName);
    }

    public JobExecutionResult execute() throws Exception {
        return this.execute(DEFAULT_JOB_NAME);
    }

    public abstract JobExecutionResult execute(String var1) throws Exception;

    public StreamGraph getStreamGraph() {
        if (this.transformations.size() <= 0) {
            throw new IllegalStateException("No operators defined in streaming topology. Cannot execute.");
        }
        return StreamGraphGenerator.generate(this, this.transformations);
    }

    public String getExecutionPlan() {
        return this.getStreamGraph().getStreamingPlanAsJSON();
    }

    public <F> F clean(F f) {
        if (this.getConfig().isClosureCleanerEnabled()) {
            ClosureCleaner.clean(f, (boolean)true);
        }
        ClosureCleaner.ensureSerializable(f);
        return f;
    }

    public void addOperator(StreamTransformation<?> transformation) {
        Preconditions.checkNotNull(transformation, "transformation must not be null.");
        this.transformations.add(transformation);
    }

    public static StreamExecutionEnvironment getExecutionEnvironment() {
        if (contextEnvironmentFactory != null) {
            return contextEnvironmentFactory.createExecutionEnvironment();
        }
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        if (env instanceof ContextEnvironment) {
            ContextEnvironment ctx = (ContextEnvironment)env;
            return StreamExecutionEnvironment.createContextEnvironment(ctx.getClient(), ctx.getJars(), ctx.getClasspaths(), ctx.getParallelism(), ctx.isWait());
        }
        if (env instanceof OptimizerPlanEnvironment | env instanceof PreviewPlanEnvironment) {
            return new StreamPlanEnvironment(env);
        }
        return StreamExecutionEnvironment.createLocalEnvironment();
    }

    private static StreamExecutionEnvironment createContextEnvironment(Client client, List<URL> jars, List<URL> classpaths, int parallelism, boolean wait) {
        return new StreamContextEnvironment(client, jars, classpaths, parallelism, wait);
    }

    public static LocalStreamEnvironment createLocalEnvironment() {
        return StreamExecutionEnvironment.createLocalEnvironment(defaultLocalParallelism);
    }

    public static LocalStreamEnvironment createLocalEnvironment(int parallelism) {
        LocalStreamEnvironment env = new LocalStreamEnvironment();
        env.setParallelism(parallelism);
        return env;
    }

    public static LocalStreamEnvironment createLocalEnvironment(int parallelism, Configuration configuration) {
        LocalStreamEnvironment currentEnvironment = new LocalStreamEnvironment(configuration);
        currentEnvironment.setParallelism(parallelism);
        return currentEnvironment;
    }

    public static StreamExecutionEnvironment createRemoteEnvironment(String host, int port, String ... jarFiles) {
        return new RemoteStreamEnvironment(host, port, jarFiles);
    }

    public static StreamExecutionEnvironment createRemoteEnvironment(String host, int port, int parallelism, String ... jarFiles) {
        RemoteStreamEnvironment env = new RemoteStreamEnvironment(host, port, jarFiles);
        env.setParallelism(parallelism);
        return env;
    }

    public static StreamExecutionEnvironment createRemoteEnvironment(String host, int port, Configuration clientConfig, String ... jarFiles) {
        return new RemoteStreamEnvironment(host, port, clientConfig, jarFiles);
    }

    protected static void initializeContextEnvironment(StreamExecutionEnvironmentFactory ctx) {
        contextEnvironmentFactory = ctx;
    }

    protected static void resetContextEnvironment() {
        contextEnvironmentFactory = null;
    }

    static {
        defaultLocalParallelism = Runtime.getRuntime().availableProcessors();
    }
}

