/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.streaming.api.collector.selector.OutputSelector;
import org.apache.flink.streaming.api.collector.selector.OutputSelectorWrapper;
import org.apache.flink.streaming.api.collector.selector.OutputSelectorWrapperFactory;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.StreamOperator;

public class StreamNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static int currentSlotSharingIndex = 1;
    private transient StreamExecutionEnvironment env;
    private Integer id;
    private Integer parallelism = null;
    private Long bufferTimeout = null;
    private String operatorName;
    private Integer slotSharingID;
    private boolean isolatedSlot = false;
    private KeySelector<?, ?> statePartitioner;
    private TypeSerializer<?> stateKeySerializer;
    private transient StreamOperator<?> operator;
    private List<OutputSelector<?>> outputSelectors;
    private TypeSerializer<?> typeSerializerIn1;
    private TypeSerializer<?> typeSerializerIn2;
    private TypeSerializer<?> typeSerializerOut;
    private List<StreamEdge> inEdges = new ArrayList<StreamEdge>();
    private List<StreamEdge> outEdges = new ArrayList<StreamEdge>();
    private Class<? extends AbstractInvokable> jobVertexClass;
    private InputFormat<?, ?> inputFormat;

    public StreamNode(StreamExecutionEnvironment env, Integer id, StreamOperator<?> operator, String operatorName, List<OutputSelector<?>> outputSelector, Class<? extends AbstractInvokable> jobVertexClass) {
        this.env = env;
        this.id = id;
        this.operatorName = operatorName;
        this.operator = operator;
        this.outputSelectors = outputSelector;
        this.jobVertexClass = jobVertexClass;
        this.slotSharingID = currentSlotSharingIndex;
    }

    public void addInEdge(StreamEdge inEdge) {
        if (inEdge.getTargetId() != this.getId().intValue()) {
            throw new IllegalArgumentException("Destination id doesn't match the StreamNode id");
        }
        this.inEdges.add(inEdge);
    }

    public void addOutEdge(StreamEdge outEdge) {
        if (outEdge.getSourceId() != this.getId().intValue()) {
            throw new IllegalArgumentException("Source id doesn't match the StreamNode id");
        }
        this.outEdges.add(outEdge);
    }

    public List<StreamEdge> getOutEdges() {
        return this.outEdges;
    }

    public List<StreamEdge> getInEdges() {
        return this.inEdges;
    }

    public List<Integer> getOutEdgeIndices() {
        ArrayList<Integer> outEdgeIndices = new ArrayList<Integer>();
        for (StreamEdge edge : this.outEdges) {
            outEdgeIndices.add(edge.getTargetId());
        }
        return outEdgeIndices;
    }

    public List<Integer> getInEdgeIndices() {
        ArrayList<Integer> inEdgeIndices = new ArrayList<Integer>();
        for (StreamEdge edge : this.inEdges) {
            inEdgeIndices.add(edge.getSourceId());
        }
        return inEdgeIndices;
    }

    public Integer getId() {
        return this.id;
    }

    public int getParallelism() {
        if (this.parallelism == -1) {
            return this.env.getParallelism();
        }
        return this.parallelism;
    }

    public void setParallelism(Integer parallelism) {
        this.parallelism = parallelism;
    }

    public Long getBufferTimeout() {
        return this.bufferTimeout != null ? this.bufferTimeout.longValue() : this.env.getBufferTimeout();
    }

    public void setBufferTimeout(Long bufferTimeout) {
        this.bufferTimeout = bufferTimeout;
    }

    public StreamOperator<?> getOperator() {
        return this.operator;
    }

    public void setOperator(StreamOperator<?> operator) {
        this.operator = operator;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public List<OutputSelector<?>> getOutputSelectors() {
        return this.outputSelectors;
    }

    public OutputSelectorWrapper<?> getOutputSelectorWrapper() {
        return OutputSelectorWrapperFactory.create(this.getOutputSelectors());
    }

    public void addOutputSelector(OutputSelector<?> outputSelector) {
        this.outputSelectors.add(outputSelector);
    }

    public TypeSerializer<?> getTypeSerializerIn1() {
        return this.typeSerializerIn1;
    }

    public void setSerializerIn1(TypeSerializer<?> typeSerializerIn1) {
        this.typeSerializerIn1 = typeSerializerIn1;
    }

    public TypeSerializer<?> getTypeSerializerIn2() {
        return this.typeSerializerIn2;
    }

    public void setSerializerIn2(TypeSerializer<?> typeSerializerIn2) {
        this.typeSerializerIn2 = typeSerializerIn2;
    }

    public TypeSerializer<?> getTypeSerializerOut() {
        return this.typeSerializerOut;
    }

    public void setSerializerOut(TypeSerializer<?> typeSerializerOut) {
        this.typeSerializerOut = typeSerializerOut;
    }

    public Class<? extends AbstractInvokable> getJobVertexClass() {
        return this.jobVertexClass;
    }

    public InputFormat<?, ?> getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(InputFormat<?, ?> inputFormat) {
        this.inputFormat = inputFormat;
    }

    public int getSlotSharingID() {
        return this.isolatedSlot ? -1 : this.slotSharingID;
    }

    public void startNewSlotSharingGroup() {
        this.slotSharingID = ++currentSlotSharingIndex;
    }

    public void isolateSlot() {
        this.isolatedSlot = true;
    }

    public String toString() {
        return this.operatorName + "-" + this.id;
    }

    public KeySelector<?, ?> getStatePartitioner() {
        return this.statePartitioner;
    }

    public void setStatePartitioner(KeySelector<?, ?> statePartitioner) {
        this.statePartitioner = statePartitioner;
    }

    public TypeSerializer<?> getStateKeySerializer() {
        return this.stateKeySerializer;
    }

    public void setStateKeySerializer(TypeSerializer<?> stateKeySerializer) {
        this.stateKeySerializer = stateKeySerializer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamNode that = (StreamNode)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

