/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.assigners;

import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.GlobalWindow;

public class GlobalWindows
extends WindowAssigner<Object, GlobalWindow> {
    private static final long serialVersionUID = 1L;

    private GlobalWindows() {
    }

    @Override
    public Collection<GlobalWindow> assignWindows(Object element, long timestamp) {
        return Collections.singletonList(GlobalWindow.get());
    }

    @Override
    public Trigger<Object, GlobalWindow> getDefaultTrigger(StreamExecutionEnvironment env) {
        return new NeverTrigger();
    }

    public String toString() {
        return "GlobalWindows()";
    }

    public static GlobalWindows create() {
        return new GlobalWindows();
    }

    @Override
    public TypeSerializer<GlobalWindow> getWindowSerializer(ExecutionConfig executionConfig) {
        return new GlobalWindow.Serializer();
    }

    private static class NeverTrigger
    implements Trigger<Object, GlobalWindow> {
        private static final long serialVersionUID = 1L;

        private NeverTrigger() {
        }

        @Override
        public Trigger.TriggerResult onElement(Object element, long timestamp, GlobalWindow window, Trigger.TriggerContext ctx) {
            return Trigger.TriggerResult.CONTINUE;
        }

        @Override
        public Trigger.TriggerResult onEventTime(long time, GlobalWindow window, Trigger.TriggerContext ctx) {
            return Trigger.TriggerResult.CONTINUE;
        }

        @Override
        public Trigger.TriggerResult onProcessingTime(long time, GlobalWindow window, Trigger.TriggerContext ctx) {
            return Trigger.TriggerResult.CONTINUE;
        }
    }
}

