/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.evictors;

import org.apache.flink.shaded.com.google.common.collect.Iterables;
import org.apache.flink.streaming.api.functions.windowing.delta.DeltaFunction;
import org.apache.flink.streaming.api.windowing.evictors.Evictor;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class DeltaEvictor<T, W extends Window>
implements Evictor<T, W> {
    private static final long serialVersionUID = 1L;
    DeltaFunction<T> deltaFunction;
    private double threshold;

    private DeltaEvictor(double threshold, DeltaFunction<T> deltaFunction) {
        this.deltaFunction = deltaFunction;
        this.threshold = threshold;
    }

    @Override
    public int evict(Iterable<StreamRecord<T>> elements, int size, W window) {
        StreamRecord<T> lastElement = Iterables.getLast(elements);
        int toEvict = 0;
        for (StreamRecord<T> element : elements) {
            if (this.deltaFunction.getDelta(element.getValue(), lastElement.getValue()) < this.threshold) break;
            ++toEvict;
        }
        return toEvict;
    }

    public String toString() {
        return "DeltaEvictor(" + this.deltaFunction + ", " + this.threshold + ")";
    }

    public static <T, W extends Window> DeltaEvictor<T, W> of(double threshold, DeltaFunction<T> deltaFunction) {
        return new DeltaEvictor<T, W>(threshold, deltaFunction);
    }
}

