/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.time;

import java.util.concurrent.TimeUnit;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.streaming.api.TimeCharacteristic;

public abstract class AbstractTime {
    private final TimeUnit unit;
    private final long size;

    protected AbstractTime(long size, TimeUnit unit) {
        this.unit = Preconditions.checkNotNull(unit, "time unit may not be null");
        this.size = size;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long getSize() {
        return this.size;
    }

    public long toMilliseconds() {
        return this.unit.toMillis(this.size);
    }

    public abstract AbstractTime makeSpecificBasedOnTimeCharacteristic(TimeCharacteristic var1);

    public int hashCode() {
        return 31 * (int)(this.size ^ this.size >>> 32) + this.unit.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            AbstractTime that = (AbstractTime)obj;
            return this.size == that.size && this.unit.equals((Object)that.unit);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + this.size + ' ' + this.unit.name() + ')';
    }
}

