/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.triggers;

import org.apache.flink.api.common.state.OperatorState;
import org.apache.flink.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.streaming.api.windowing.time.AbstractTime;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;

public class ContinuousEventTimeTrigger<W extends Window>
implements Trigger<Object, W> {
    private static final long serialVersionUID = 1L;
    private final long interval;

    private ContinuousEventTimeTrigger(long interval) {
        this.interval = interval;
    }

    @Override
    public Trigger.TriggerResult onElement(Object element, long timestamp, W window, Trigger.TriggerContext ctx) throws Exception {
        OperatorState<Boolean> first = ctx.getKeyValueState("first", true);
        if (((Boolean)first.value()).booleanValue()) {
            long start = timestamp - timestamp % this.interval;
            long nextFireTimestamp = start + this.interval;
            ctx.registerEventTimeTimer(nextFireTimestamp);
            first.update((Object)false);
            return Trigger.TriggerResult.CONTINUE;
        }
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onEventTime(long time, W window, Trigger.TriggerContext ctx) {
        ctx.registerEventTimeTimer(time + this.interval);
        return Trigger.TriggerResult.FIRE;
    }

    @Override
    public Trigger.TriggerResult onProcessingTime(long time, W window, Trigger.TriggerContext ctx) throws Exception {
        return Trigger.TriggerResult.CONTINUE;
    }

    public String toString() {
        return "ContinuousProcessingTimeTrigger(" + this.interval + ")";
    }

    @VisibleForTesting
    public long getInterval() {
        return this.interval;
    }

    public static <W extends Window> ContinuousEventTimeTrigger<W> of(AbstractTime interval) {
        return new ContinuousEventTimeTrigger<W>(interval.toMilliseconds());
    }
}

