/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.triggers;

import org.apache.flink.api.common.state.OperatorState;
import org.apache.flink.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.streaming.api.windowing.time.AbstractTime;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;

public class ContinuousProcessingTimeTrigger<W extends Window>
implements Trigger<Object, W> {
    private static final long serialVersionUID = 1L;
    private final long interval;

    private ContinuousProcessingTimeTrigger(long interval) {
        this.interval = interval;
    }

    @Override
    public Trigger.TriggerResult onElement(Object element, long timestamp, W window, Trigger.TriggerContext ctx) throws Exception {
        long currentTime = System.currentTimeMillis();
        OperatorState<Long> fireState = ctx.getKeyValueState("fire-timestamp", 0L);
        long nextFireTimestamp = (Long)fireState.value();
        if (nextFireTimestamp == 0L) {
            long start = currentTime - currentTime % this.interval;
            fireState.update((Object)(start + this.interval));
            ctx.registerProcessingTimeTimer(nextFireTimestamp);
            return Trigger.TriggerResult.CONTINUE;
        }
        if (currentTime > nextFireTimestamp) {
            long start = currentTime - currentTime % this.interval;
            fireState.update((Object)(start + this.interval));
            ctx.registerProcessingTimeTimer(nextFireTimestamp);
            return Trigger.TriggerResult.FIRE;
        }
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onEventTime(long time, W window, Trigger.TriggerContext ctx) throws Exception {
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onProcessingTime(long time, W window, Trigger.TriggerContext ctx) throws Exception {
        OperatorState<Long> fireState = ctx.getKeyValueState("fire-timestamp", 0L);
        long nextFireTimestamp = (Long)fireState.value();
        long currentTime = System.currentTimeMillis();
        if (currentTime > nextFireTimestamp) {
            long start = currentTime - currentTime % this.interval;
            fireState.update((Object)(start + this.interval));
            return Trigger.TriggerResult.FIRE;
        }
        return Trigger.TriggerResult.CONTINUE;
    }

    @VisibleForTesting
    public long getInterval() {
        return this.interval;
    }

    public String toString() {
        return "ContinuousProcessingTimeTrigger(" + this.interval + ")";
    }

    public static <W extends Window> ContinuousProcessingTimeTrigger<W> of(AbstractTime interval) {
        return new ContinuousProcessingTimeTrigger<W>(interval.toMilliseconds());
    }
}

