/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.triggers;

import java.io.IOException;
import org.apache.flink.api.common.state.OperatorState;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;

public class CountTrigger<W extends Window>
implements Trigger<Object, W> {
    private static final long serialVersionUID = 1L;
    private final long maxCount;

    private CountTrigger(long maxCount) {
        this.maxCount = maxCount;
    }

    @Override
    public Trigger.TriggerResult onElement(Object element, long timestamp, W window, Trigger.TriggerContext ctx) throws IOException {
        OperatorState<Long> count = ctx.getKeyValueState("count", 0L);
        long currentCount = (Long)count.value() + 1L;
        count.update((Object)currentCount);
        if (currentCount >= this.maxCount) {
            count.update((Object)0L);
            return Trigger.TriggerResult.FIRE;
        }
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onEventTime(long time, W window, Trigger.TriggerContext ctx) {
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onProcessingTime(long time, W window, Trigger.TriggerContext ctx) throws Exception {
        return Trigger.TriggerResult.CONTINUE;
    }

    public String toString() {
        return "CountTrigger(" + this.maxCount + ")";
    }

    public static <W extends Window> CountTrigger<W> of(long maxCount) {
        return new CountTrigger<W>(maxCount);
    }
}

