/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.triggers;

import java.io.Serializable;
import org.apache.flink.api.common.state.OperatorState;
import org.apache.flink.streaming.api.functions.windowing.delta.DeltaFunction;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;

public class DeltaTrigger<T extends Serializable, W extends Window>
implements Trigger<T, W> {
    private static final long serialVersionUID = 1L;
    private final DeltaFunction<T> deltaFunction;
    private final double threshold;

    private DeltaTrigger(double threshold, DeltaFunction<T> deltaFunction) {
        this.deltaFunction = deltaFunction;
        this.threshold = threshold;
    }

    @Override
    public Trigger.TriggerResult onElement(T element, long timestamp, W window, Trigger.TriggerContext ctx) throws Exception {
        OperatorState<Object> lastElementState = ctx.getKeyValueState("last-element", null);
        if (lastElementState.value() == null) {
            lastElementState.update(element);
            return Trigger.TriggerResult.CONTINUE;
        }
        if (this.deltaFunction.getDelta(lastElementState.value(), element) > this.threshold) {
            lastElementState.update(element);
            return Trigger.TriggerResult.FIRE;
        }
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onEventTime(long time, W window, Trigger.TriggerContext ctx) {
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onProcessingTime(long time, W window, Trigger.TriggerContext ctx) throws Exception {
        return Trigger.TriggerResult.CONTINUE;
    }

    public String toString() {
        return "DeltaTrigger(" + this.deltaFunction + ", " + this.threshold + ")";
    }

    public static <T extends Serializable, W extends Window> DeltaTrigger<T, W> of(double threshold, DeltaFunction<T> deltaFunction) {
        return new DeltaTrigger<T, W>(threshold, deltaFunction);
    }
}

