/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.windowing.triggers;

import org.apache.flink.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.windows.Window;

public class PurgingTrigger<T, W extends Window>
implements Trigger<T, W> {
    private static final long serialVersionUID = 1L;
    private Trigger<T, W> nestedTrigger;

    private PurgingTrigger(Trigger<T, W> nestedTrigger) {
        this.nestedTrigger = nestedTrigger;
    }

    @Override
    public Trigger.TriggerResult onElement(T element, long timestamp, W window, Trigger.TriggerContext ctx) throws Exception {
        Trigger.TriggerResult triggerResult = this.nestedTrigger.onElement(element, timestamp, window, ctx);
        switch (triggerResult) {
            case FIRE: {
                return Trigger.TriggerResult.FIRE_AND_PURGE;
            }
            case FIRE_AND_PURGE: {
                return Trigger.TriggerResult.FIRE_AND_PURGE;
            }
        }
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onEventTime(long time, W window, Trigger.TriggerContext ctx) throws Exception {
        Trigger.TriggerResult triggerResult = this.nestedTrigger.onEventTime(time, window, ctx);
        switch (triggerResult) {
            case FIRE: {
                return Trigger.TriggerResult.FIRE_AND_PURGE;
            }
            case FIRE_AND_PURGE: {
                return Trigger.TriggerResult.FIRE_AND_PURGE;
            }
        }
        return Trigger.TriggerResult.CONTINUE;
    }

    @Override
    public Trigger.TriggerResult onProcessingTime(long time, W window, Trigger.TriggerContext ctx) throws Exception {
        Trigger.TriggerResult triggerResult = this.nestedTrigger.onProcessingTime(time, window, ctx);
        switch (triggerResult) {
            case FIRE: {
                return Trigger.TriggerResult.FIRE_AND_PURGE;
            }
            case FIRE_AND_PURGE: {
                return Trigger.TriggerResult.FIRE_AND_PURGE;
            }
        }
        return Trigger.TriggerResult.CONTINUE;
    }

    public String toString() {
        return "PurgingTrigger(" + this.nestedTrigger.toString() + ")";
    }

    public static <T, W extends Window> PurgingTrigger<T, W> of(Trigger<T, W> nestedTrigger) {
        return new PurgingTrigger<T, W>(nestedTrigger);
    }

    @VisibleForTesting
    public Trigger<T, W> getNestedTrigger() {
        return this.nestedTrigger;
    }
}

