/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.runtime.util.MathUtils;

public class KeyMap<K, V>
implements Iterable<Entry<K, V>> {
    private static final int MIN_CAPACITY = 64;
    private static final int MAX_CAPACITY = 0x40000000;
    private static final int FULL_BIT_RANGE = MathUtils.log2strict((int)0x40000000);
    private Entry<K, V>[] table;
    private int shift;
    private int numElements;
    private int rehashThreshold;
    private int log2size;

    public KeyMap() {
        this(0);
    }

    public KeyMap(int expectedNumberOfElements) {
        if (expectedNumberOfElements < 0) {
            throw new IllegalArgumentException("Invalid capacity: " + expectedNumberOfElements);
        }
        int capacity = Integer.highestOneBit(expectedNumberOfElements) << 1;
        capacity = capacity >= 0 ? Math.max(64, capacity) : 0x40000000;
        this.log2size = MathUtils.log2strict((int)capacity);
        this.shift = FULL_BIT_RANGE - this.log2size;
        this.table = this.allocateTable(capacity);
        this.rehashThreshold = KeyMap.getRehashThreshold(capacity);
    }

    public final V put(K key, V value) {
        int hash = KeyMap.hash(key);
        int slot = this.indexOf(hash);
        Entry<K, V> e = this.table[slot];
        while (e != null) {
            Object k;
            if (e.hashCode == hash && ((k = e.key) == key || key.equals(k))) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        this.insertNewEntry(hash, key, value, slot);
        return null;
    }

    public final V putIfAbsent(K key, LazyFactory<V> factory) {
        int hash = KeyMap.hash(key);
        int slot = this.indexOf(hash);
        Entry<K, V> entry = this.table[slot];
        while (entry != null) {
            if (entry.hashCode == hash && entry.key.equals(key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        V value = factory.create();
        this.insertNewEntry(hash, key, value, slot);
        return value;
    }

    public final V putOrAggregate(K key, V value, ReduceFunction<V> aggregator) throws Exception {
        int hash = KeyMap.hash(key);
        int slot = this.indexOf(hash);
        Entry<K, V> entry = this.table[slot];
        while (entry != null) {
            if (entry.hashCode == hash && entry.key.equals(key)) {
                entry.value = aggregator.reduce(entry.value, value);
                return entry.value;
            }
            entry = entry.next;
        }
        this.insertNewEntry(hash, key, value, slot);
        return value;
    }

    public V get(K key) {
        int hash = KeyMap.hash(key);
        int slot = this.indexOf(hash);
        Entry<K, V> entry = this.table[slot];
        while (entry != null) {
            if (entry.hashCode == hash && entry.key.equals(key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private void insertNewEntry(int hashCode, K key, V value, int position) {
        Entry<K, V> e = this.table[position];
        this.table[position] = new Entry<K, V>(key, value, hashCode, e);
        ++this.numElements;
        if (this.numElements > this.rehashThreshold) {
            this.growTable();
        }
    }

    private int indexOf(int hashCode) {
        return hashCode >> this.shift & this.table.length - 1;
    }

    @Override
    public Iterator<Entry<K, V>> iterator() {
        return new Iterator<Entry<K, V>>(){
            private final Entry<K, V>[] tab;
            private Entry<K, V> nextEntry;
            private int nextPos;
            {
                this.tab = KeyMap.this.table;
                this.nextPos = 0;
            }

            @Override
            public boolean hasNext() {
                if (this.nextEntry != null) {
                    return true;
                }
                while (this.nextPos < this.tab.length) {
                    Entry e;
                    if ((e = this.tab[this.nextPos++]) == null) continue;
                    this.nextEntry = e;
                    return true;
                }
                return false;
            }

            @Override
            public Entry<K, V> next() {
                if (this.nextEntry != null || this.hasNext()) {
                    Entry e = this.nextEntry;
                    this.nextEntry = this.nextEntry.next;
                    return e;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.numElements;
    }

    public boolean isEmpty() {
        return this.numElements == 0;
    }

    public int getCurrentTableCapacity() {
        return this.table.length;
    }

    public int getLog2TableCapacity() {
        return this.log2size;
    }

    public int getRehashThreshold() {
        return this.rehashThreshold;
    }

    public int getShift() {
        return this.shift;
    }

    private Entry<K, V>[] allocateTable(int numElements) {
        return new Entry[numElements];
    }

    private void growTable() {
        int newSize = this.table.length << 1;
        if (newSize > 0) {
            Entry<K, V>[] oldTable = this.table;
            Entry<K, V>[] newTable = this.allocateTable(newSize);
            int newShift = this.shift - 1;
            int newMask = newSize - 1;
            for (Entry<K, V> entry : oldTable) {
                while (entry != null) {
                    int newPos = entry.hashCode >> newShift & newMask;
                    Entry nextEntry = entry.next;
                    entry.next = newTable[newPos];
                    newTable[newPos] = entry;
                    entry = nextEntry;
                }
            }
            this.table = newTable;
            this.shift = newShift;
            this.rehashThreshold = KeyMap.getRehashThreshold(newSize);
            ++this.log2size;
        }
    }

    private static int hash(Object key) {
        int code = key.hashCode();
        code = code + 2127912214 + (code << 12);
        code = code ^ 0xC761C23C ^ code >>> 19;
        code = code + 374761393 + (code << 5);
        code = code + -744332180 ^ code << 9;
        code = code + -42973499 + (code << 3);
        return code ^ 0xB55A4F09 ^ code >>> 16;
    }

    private static int getRehashThreshold(int capacity) {
        return capacity / 4 * 3;
    }

    int traverseAndCountElements() {
        int num = 0;
        for (Entry<K, V> entry : this.table) {
            while (entry != null) {
                ++num;
                entry = entry.next;
            }
        }
        return num;
    }

    int getLongestChainLength() {
        int maxLen = 0;
        for (Entry<K, V> entry : this.table) {
            int thisLen = 0;
            while (entry != null) {
                ++thisLen;
                entry = entry.next;
            }
            maxLen = Math.max(maxLen, thisLen);
        }
        return maxLen;
    }

    public static <K, V> void traverseMaps(KeyMap<K, V>[] maps, TraversalEvaluator<K, V> visitor, long touchedTag) throws Exception {
        Arrays.sort(maps, CapacityDescendingComparator.INSTANCE);
        int[] shifts = new int[maps.length];
        int[] lowBitsMask = new int[maps.length];
        int numSlots = maps[0].table.length;
        int numTables = maps.length;
        for (int i = 0; i < numTables; ++i) {
            shifts[i] = maps[0].log2size - maps[i].log2size;
            lowBitsMask[i] = (1 << shifts[i]) - 1;
        }
        for (int pos = 0; pos < numSlots; ++pos) {
            int mask;
            for (int rootTable = 0; rootTable < numTables && ((mask = lowBitsMask[rootTable]) & pos) == mask; ++rootTable) {
                Entry<K, V> entry = maps[rootTable].table[pos >> shifts[rootTable]];
                while (entry != null) {
                    if (entry.touchedTag < touchedTag) {
                        entry.touchedTag = touchedTag;
                        Object key = entry.key;
                        int hashCode = entry.hashCode;
                        visitor.startNewKey(key);
                        visitor.nextValue(entry.value);
                        KeyMap.addEntriesFromChain(entry.next, visitor, key, touchedTag, hashCode);
                        for (int followupTable = rootTable + 1; followupTable < numTables; ++followupTable) {
                            Entry<K, V> followupEntry = maps[followupTable].table[pos >> shifts[followupTable]];
                            if (followupEntry == null) continue;
                            KeyMap.addEntriesFromChain(followupEntry, visitor, key, touchedTag, hashCode);
                        }
                        visitor.keyDone();
                    }
                    entry = entry.next;
                }
            }
        }
    }

    private static <K, V> void addEntriesFromChain(Entry<K, V> entry, TraversalEvaluator<K, V> visitor, K key, long touchedTag, int hashCode) throws Exception {
        while (entry != null) {
            if (entry.touchedTag < touchedTag && entry.hashCode == hashCode && entry.key.equals(key)) {
                entry.touchedTag = touchedTag;
                visitor.nextValue(entry.value);
            }
            entry = entry.next;
        }
    }

    public static interface TraversalEvaluator<K, V> {
        public void startNewKey(K var1) throws Exception;

        public void nextValue(V var1) throws Exception;

        public void keyDone() throws Exception;
    }

    public static interface LazyFactory<V> {
        public V create();
    }

    static final class CapacityDescendingComparator
    implements Comparator<KeyMap<?, ?>> {
        static final CapacityDescendingComparator INSTANCE = new CapacityDescendingComparator();

        private CapacityDescendingComparator() {
        }

        @Override
        public int compare(KeyMap<?, ?> o1, KeyMap<?, ?> o2) {
            int cmp = o2.getLog2TableCapacity() - o1.getLog2TableCapacity();
            if (cmp != 0) {
                return cmp;
            }
            return o2.size() - o1.size();
        }
    }

    public static final class Entry<K, V> {
        final K key;
        final int hashCode;
        V value;
        Entry<K, V> next;
        long touchedTag;

        Entry(K key, V value, int hashCode, Entry<K, V> next) {
            this.key = key;
            this.value = value;
            this.next = next;
            this.hashCode = hashCode;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

