/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing.buffers;

import java.util.ArrayDeque;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.shaded.com.google.common.base.Function;
import org.apache.flink.shaded.com.google.common.collect.FluentIterable;
import org.apache.flink.streaming.runtime.operators.windowing.buffers.EvictingWindowBuffer;
import org.apache.flink.streaming.runtime.operators.windowing.buffers.WindowBufferFactory;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class HeapWindowBuffer<T>
implements EvictingWindowBuffer<T> {
    private static final long serialVersionUID = 1L;
    private ArrayDeque<StreamRecord<T>> elements = new ArrayDeque();

    protected HeapWindowBuffer() {
    }

    @Override
    public void storeElement(StreamRecord<T> element) {
        this.elements.add(element);
    }

    @Override
    public void removeElements(int count) {
        for (int i = 0; i < count; ++i) {
            this.elements.removeFirst();
        }
    }

    @Override
    public Iterable<StreamRecord<T>> getElements() {
        return this.elements;
    }

    @Override
    public Iterable<T> getUnpackedElements() {
        return FluentIterable.from(this.elements).transform(new Function<StreamRecord<T>, T>(){

            @Override
            public T apply(StreamRecord<T> record) {
                return record.getValue();
            }
        });
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    public static class Factory<T>
    implements WindowBufferFactory<T, HeapWindowBuffer<T>> {
        private static final long serialVersionUID = 1L;

        @Override
        public void setRuntimeContext(RuntimeContext ctx) {
        }

        @Override
        public void open(Configuration config) {
        }

        @Override
        public void close() {
        }

        @Override
        public HeapWindowBuffer<T> create() {
            return new HeapWindowBuffer();
        }
    }
}

