/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamrecord;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecordSerializer;

public final class MultiplexingStreamRecordSerializer<T>
extends TypeSerializer<StreamElement> {
    private static final long serialVersionUID = 1L;
    private static final long IS_WATERMARK = Long.MIN_VALUE;
    private final TypeSerializer<T> typeSerializer;

    public MultiplexingStreamRecordSerializer(TypeSerializer<T> serializer) {
        if (serializer instanceof MultiplexingStreamRecordSerializer || serializer instanceof StreamRecordSerializer) {
            throw new RuntimeException("StreamRecordSerializer given to StreamRecordSerializer as value TypeSerializer: " + serializer);
        }
        this.typeSerializer = Preconditions.checkNotNull(serializer);
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<StreamElement> duplicate() {
        TypeSerializer copy = this.typeSerializer.duplicate();
        return copy == this.typeSerializer ? this : new MultiplexingStreamRecordSerializer<T>(copy);
    }

    public StreamRecord<T> createInstance() {
        return new StreamRecord<Object>(this.typeSerializer.createInstance(), 0L);
    }

    public StreamElement copy(StreamElement from) {
        if (from.isRecord()) {
            StreamRecord fromRecord = from.asRecord();
            return new StreamRecord<Object>(this.typeSerializer.copy(fromRecord.getValue()), fromRecord.getTimestamp());
        }
        if (from.isWatermark()) {
            return from;
        }
        throw new RuntimeException("Cannot copy " + from);
    }

    public StreamElement copy(StreamElement from, StreamElement reuse) {
        if (from.isRecord() && reuse.isRecord()) {
            StreamRecord fromRecord = from.asRecord();
            StreamRecord reuseRecord = reuse.asRecord();
            Object valueCopy = this.typeSerializer.copy(fromRecord.getValue(), reuseRecord.getValue());
            reuseRecord.replace(valueCopy, fromRecord.getTimestamp());
            return reuse;
        }
        if (from.isWatermark()) {
            return from;
        }
        throw new RuntimeException("Cannot copy " + from + " -> " + reuse);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(StreamElement value, DataOutputView target) throws IOException {
        if (value.isRecord()) {
            StreamRecord record = value.asRecord();
            target.writeLong(record.getTimestamp());
            this.typeSerializer.serialize(record.getValue(), target);
        } else if (value.isWatermark()) {
            target.writeLong(Long.MIN_VALUE);
            target.writeLong(value.asWatermark().getTimestamp());
        } else {
            throw new RuntimeException();
        }
    }

    public StreamElement deserialize(DataInputView source) throws IOException {
        long millis = source.readLong();
        if (millis == Long.MIN_VALUE) {
            return new Watermark(source.readLong());
        }
        Object element = this.typeSerializer.deserialize(source);
        return new StreamRecord<Object>(element, millis);
    }

    public StreamElement deserialize(StreamElement reuse, DataInputView source) throws IOException {
        long millis = source.readLong();
        if (millis == Long.MIN_VALUE) {
            return new Watermark(source.readLong());
        }
        StreamRecord reuseRecord = reuse.asRecord();
        Object element = this.typeSerializer.deserialize(reuseRecord.getValue(), source);
        reuseRecord.replace(element, millis);
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        long millis = source.readLong();
        target.writeLong(millis);
        if (millis == Long.MIN_VALUE) {
            target.writeLong(source.readLong());
        } else {
            this.typeSerializer.copy(source, target);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof MultiplexingStreamRecordSerializer) {
            MultiplexingStreamRecordSerializer other = (MultiplexingStreamRecordSerializer)((Object)obj);
            return other.canEqual((Object)this) && this.typeSerializer.equals(other.typeSerializer);
        }
        return false;
    }

    public boolean canEqual(Object obj) {
        return obj instanceof MultiplexingStreamRecordSerializer;
    }

    public int hashCode() {
        return this.typeSerializer.hashCode();
    }
}

