/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.flink.runtime.state.KvStateSnapshot;
import org.apache.flink.runtime.state.StateHandle;

public class StreamTaskState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private StateHandle<?> operatorState;
    private StateHandle<Serializable> functionState;
    private HashMap<String, KvStateSnapshot<?, ?, ?>> kvStates;

    public StateHandle<?> getOperatorState() {
        return this.operatorState;
    }

    public void setOperatorState(StateHandle<?> operatorState) {
        this.operatorState = operatorState;
    }

    public StateHandle<Serializable> getFunctionState() {
        return this.functionState;
    }

    public void setFunctionState(StateHandle<Serializable> functionState) {
        this.functionState = functionState;
    }

    public HashMap<String, KvStateSnapshot<?, ?, ?>> getKvStates() {
        return this.kvStates;
    }

    public void setKvStates(HashMap<String, KvStateSnapshot<?, ?, ?>> kvStates) {
        this.kvStates = kvStates;
    }

    public boolean isEmpty() {
        return this.operatorState == null & this.functionState == null & this.kvStates == null;
    }

    public void discardState() throws Exception {
        StateHandle<?> operatorState = this.operatorState;
        StateHandle<Serializable> functionState = this.functionState;
        HashMap<String, KvStateSnapshot<?, ?, ?>> kvStates = this.kvStates;
        if (operatorState != null) {
            operatorState.discardState();
        }
        if (functionState != null) {
            functionState.discardState();
        }
        if (kvStates != null) {
            while (kvStates.size() > 0) {
                try {
                    Iterator<KvStateSnapshot<?, ?, ?>> values = kvStates.values().iterator();
                    while (values.hasNext()) {
                        KvStateSnapshot<?, ?, ?> s = values.next();
                        s.discardState();
                        values.remove();
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                }
            }
        }
        this.operatorState = null;
        this.functionState = null;
        this.kvStates = null;
    }
}

