/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.file;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.avro.file.Codec;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;

class DeflateCodec
extends Codec {
    DataFileWriter.NonCopyingByteArrayOutputStream compressionBuffer;
    private Deflater deflater;
    private Inflater inflater;
    private boolean nowrap = true;
    private int compressionLevel;

    public DeflateCodec(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    @Override
    String getName() {
        return "deflate";
    }

    @Override
    ByteBuffer compress(ByteBuffer data) throws IOException {
        if (this.compressionBuffer == null) {
            this.compressionBuffer = new DataFileWriter.NonCopyingByteArrayOutputStream(data.remaining());
        }
        if (this.deflater == null) {
            this.deflater = new Deflater(this.compressionLevel, this.nowrap);
        }
        DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)this.compressionBuffer, this.deflater);
        deflaterStream.write(data.array(), data.position() + data.arrayOffset(), data.limit() + data.arrayOffset());
        deflaterStream.finish();
        ByteBuffer result = this.compressionBuffer.getByteArrayAsByteBuffer();
        this.deflater.reset();
        this.compressionBuffer.reset();
        return result;
    }

    @Override
    ByteBuffer decompress(ByteBuffer data) throws IOException {
        if (this.compressionBuffer == null) {
            this.compressionBuffer = new DataFileWriter.NonCopyingByteArrayOutputStream(data.remaining());
        }
        if (this.inflater == null) {
            this.inflater = new Inflater(this.nowrap);
        }
        InflaterInputStream uncompressed = new InflaterInputStream(new ByteArrayInputStream(data.array(), data.position() + data.arrayOffset(), data.remaining()), this.inflater);
        byte[] buff = new byte[2048];
        try {
            int read;
            while ((read = ((InputStream)uncompressed).read(buff)) >= 0) {
                this.compressionBuffer.write(buff, 0, read);
            }
        }
        catch (EOFException e) {
            // empty catch block
        }
        ByteBuffer result = this.compressionBuffer.getByteArrayAsByteBuffer();
        this.inflater.reset();
        this.compressionBuffer.reset();
        return result;
    }

    @Override
    public int hashCode() {
        return this.nowrap ? 0 : 1;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DeflateCodec other = (DeflateCodec)obj;
        return this.nowrap == other.nowrap;
    }

    @Override
    public String toString() {
        return this.getName() + "-" + this.compressionLevel;
    }

    static class Option
    extends CodecFactory {
        private int compressionLevel;

        public Option(int compressionLevel) {
            this.compressionLevel = compressionLevel;
        }

        @Override
        protected Codec createInstance() {
            return new DeflateCodec(this.compressionLevel);
        }
    }
}

