/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.SocketTransceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketServer
extends Thread
implements Server {
    private static final Logger LOG = LoggerFactory.getLogger(SocketServer.class);
    private Responder responder;
    private ServerSocketChannel channel;
    private ThreadGroup group;

    public SocketServer(Responder responder, SocketAddress addr) throws IOException {
        String name = "SocketServer on " + addr;
        this.responder = responder;
        this.group = new ThreadGroup(name);
        this.channel = ServerSocketChannel.open();
        this.channel.socket().bind(addr);
        this.setName(name);
        this.setDaemon(true);
        this.start();
    }

    @Override
    public int getPort() {
        return this.channel.socket().getLocalPort();
    }

    @Override
    public void run() {
        LOG.info("starting " + this.channel.socket().getInetAddress());
        while (true) {
            try {
                new Connection(this.channel.accept());
                continue;
            }
            catch (ClosedChannelException e) {
                return;
            }
            catch (IOException e) {
                LOG.warn("unexpected error", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                LOG.info("stopping " + this.channel.socket().getInetAddress());
                continue;
            }
            break;
        }
    }

    @Override
    public void close() {
        this.group.interrupt();
    }

    public static void main(String[] arg) throws Exception {
        SocketServer server = new SocketServer(null, new InetSocketAddress(0));
        System.out.println("started");
        server.join();
    }

    private class Connection
    extends SocketTransceiver
    implements Runnable {
        public Connection(SocketChannel channel) throws IOException {
            super(channel);
            Thread thread = new Thread(SocketServer.this.group, this);
            thread.setName("Connection to " + channel.socket().getRemoteSocketAddress());
            thread.setDaemon(true);
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    try {
                        while (true) {
                            this.writeBuffers(SocketServer.this.responder.respond(this.readBuffers()));
                        }
                    }
                    catch (ClosedChannelException e) {
                        this.close();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    this.close();
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOG.warn("unexpected error", (Throwable)e);
                return;
            }
        }
    }
}

