/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.base.Joiner;
import java.util.Queue;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.PendingDataNodeMessages;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.junit.Assert;
import org.junit.Test;

public class TestPendingDataNodeMessages {
    PendingDataNodeMessages msgs = new PendingDataNodeMessages();
    private final Block block1Gs1 = new Block(1L, 0L, 1L);
    private final Block block1Gs2 = new Block(1L, 0L, 2L);
    private final Block block1Gs2DifferentInstance = new Block(1L, 0L, 2L);
    private final Block block2Gs1 = new Block(2L, 0L, 1L);

    @Test
    public void testQueues() {
        DatanodeDescriptor fakeDN = DFSTestUtil.getLocalDatanodeDescriptor();
        this.msgs.enqueueReportedBlock(fakeDN, this.block1Gs1, HdfsServerConstants.ReplicaState.FINALIZED);
        this.msgs.enqueueReportedBlock(fakeDN, this.block1Gs2, HdfsServerConstants.ReplicaState.FINALIZED);
        Assert.assertEquals((long)2L, (long)this.msgs.count());
        Assert.assertNull((Object)this.msgs.takeBlockQueue(this.block2Gs1));
        Assert.assertEquals((long)2L, (long)this.msgs.count());
        Queue q = this.msgs.takeBlockQueue(this.block1Gs2DifferentInstance);
        Assert.assertEquals((Object)"ReportedBlockInfo [block=blk_1_1, dn=127.0.0.1:50010, reportedState=FINALIZED],ReportedBlockInfo [block=blk_1_2, dn=127.0.0.1:50010, reportedState=FINALIZED]", (Object)Joiner.on((String)",").join((Iterable)q));
        Assert.assertEquals((long)0L, (long)this.msgs.count());
        Assert.assertNull((Object)this.msgs.takeBlockQueue(this.block1Gs1));
        Assert.assertEquals((long)0L, (long)this.msgs.count());
    }
}

