/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;

public class Tag {
    private final String account;
    private final String customer;
    private final String domain;
    private final String domainId;
    private final String key;
    private final String project;
    private final String projectId;
    private final String resourceId;
    private final ResourceType resourceType;
    private final String value;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromTag(this);
    }

    @ConstructorProperties(value={"account", "customer", "domain", "domainid", "key", "project", "projectid", "resourceid", "resourcetype", "value"})
    protected Tag(@Nullable String account, @Nullable String customer, @Nullable String domain, @Nullable String domainId, @Nullable String key, @Nullable String project, @Nullable String projectId, @Nullable String resourceId, @Nullable ResourceType resourceType, @Nullable String value) {
        this.account = account;
        this.customer = customer;
        this.domain = domain;
        this.domainId = domainId;
        this.key = key;
        this.project = project;
        this.projectId = projectId;
        this.resourceId = resourceId;
        this.resourceType = resourceType;
        this.value = value;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    @Nullable
    public String getCustomer() {
        return this.customer;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getProject() {
        return this.project;
    }

    @Nullable
    public String getProjectId() {
        return this.projectId;
    }

    @Nullable
    public String getResourceId() {
        return this.resourceId;
    }

    @Nullable
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.account, this.customer, this.domain, this.domainId, this.key, this.project, this.projectId, this.resourceId, this.resourceType, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Tag that = (Tag)Tag.class.cast(obj);
        return Objects.equal((Object)this.account, (Object)that.account) && Objects.equal((Object)this.customer, (Object)that.customer) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.key, (Object)that.key) && Objects.equal((Object)this.project, (Object)that.project) && Objects.equal((Object)this.projectId, (Object)that.projectId) && Objects.equal((Object)this.resourceId, (Object)that.resourceId) && Objects.equal((Object)((Object)this.resourceType), (Object)((Object)that.resourceType)) && Objects.equal((Object)this.value, (Object)that.value);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("account", (Object)this.account).add("customer", (Object)this.customer).add("domain", (Object)this.domain).add("domainId", (Object)this.domainId).add("key", (Object)this.key).add("project", (Object)this.project).add("projectId", (Object)this.projectId).add("resourceId", (Object)this.resourceId).add("resourceType", (Object)this.resourceType).add("value", (Object)this.value);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String account;
        protected String customer;
        protected String domain;
        protected String domainId;
        protected String key;
        protected String project;
        protected String projectId;
        protected String resourceId;
        protected ResourceType resourceType;
        protected String value;

        protected abstract T self();

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T customer(String customer) {
            this.customer = customer;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T key(String key) {
            this.key = key;
            return this.self();
        }

        public T project(String project) {
            this.project = project;
            return this.self();
        }

        public T projectId(String projectId) {
            this.projectId = projectId;
            return this.self();
        }

        public T resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this.self();
        }

        public T resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            return this.self();
        }

        public T value(String value) {
            this.value = value;
            return this.self();
        }

        public Tag build() {
            return new Tag(this.account, this.customer, this.domain, this.domainId, this.key, this.project, this.projectId, this.resourceId, this.resourceType, this.value);
        }

        public T fromTag(Tag in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.account(in.getAccount())).customer(in.getCustomer())).domain(in.getDomain())).domainId(in.getDomainId())).key(in.getKey())).project(in.getProject())).projectId(in.getProjectId())).resourceId(in.getResourceId())).resourceType(in.getResourceType())).value(in.getValue());
        }
    }

    public static enum ResourceType {
        USER_VM("UserVm"),
        TEMPLATE("Template"),
        ISO("ISO"),
        VOLUME("Volume"),
        SNAPSHOT("Snapshot"),
        NETWORK("Network"),
        NIC("Nic"),
        LOAD_BALANCER("LoadBalancer"),
        PORT_FORWARDING_RULE("PortForwardingRule"),
        FIREWALL_RULE("FirewallRule"),
        SECURITY_GROUP("SecurityGroup"),
        PUBLIC_IP_ADDRESS("PublicIpAddress"),
        PROJECT("Project"),
        VPC("Vpc"),
        NETWORK_ACL("NetworkACL"),
        STATIC_ROUTE("StaticRoute"),
        VM_SNAPSHOT("VMSnapshot"),
        REMOTE_ACCESS_VPN("RemoteAccessVpn"),
        ZONE("Zone"),
        SERVICE_OFFERING("ServiceOffering"),
        STORAGE("Storage"),
        PRIVATE_GATEWAY("PrivateGateway"),
        NETWORK_ACL_LIST("NetworkACLList"),
        VPN_GATEWAY("VpnGateway"),
        CUSTOMER_GATEWAY("CustomerGateway"),
        VPN_CONNECTION("VpnConnection"),
        UNRECOGNIZED("");

        private String code;
        private static final Map<String, ResourceType> INDEX;

        private ResourceType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public String toString() {
            return this.code;
        }

        public static ResourceType fromValue(String resourceType) {
            String code = (String)Preconditions.checkNotNull((Object)resourceType, (Object)"resourcetype");
            return INDEX.containsKey(code) ? INDEX.get(code) : UNRECOGNIZED;
        }

        static {
            INDEX = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])ResourceType.values()), (Function)new Function<ResourceType, String>(){

                public String apply(ResourceType input) {
                    return input.code;
                }
            });
        }
    }
}

