/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.options;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Bytes;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.domain.BlockDeviceMapping;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.domain.Statement;

public class EC2TemplateOptions
extends TemplateOptions
implements Cloneable {
    private Set<String> groupNames = ImmutableSet.of();
    private String keyPair = null;
    private boolean noKeyPair;
    private List<Byte> userData;
    private ImmutableSet.Builder<BlockDeviceMapping> blockDeviceMappings = ImmutableSet.builder();
    private Integer maxCount;
    private String clientToken = null;
    public static final EC2TemplateOptions NONE = new EC2TemplateOptions();

    public EC2TemplateOptions clone() {
        EC2TemplateOptions options = new EC2TemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof EC2TemplateOptions) {
            EC2TemplateOptions eTo = (EC2TemplateOptions)EC2TemplateOptions.class.cast(to);
            if (!this.getGroups().isEmpty()) {
                eTo.securityGroups(this.getGroups());
            }
            if (this.getKeyPair() != null) {
                eTo.keyPair(this.getKeyPair());
            }
            if (!this.getBlockDeviceMappings().isEmpty()) {
                eTo.blockDeviceMappings(this.getBlockDeviceMappings());
            }
            if (!this.shouldAutomaticallyCreateKeyPair()) {
                eTo.noKeyPair();
            }
            if (this.getUserData() != null) {
                eTo.userData(this.getUserData());
            }
            if (this.getMaxCount() > 0) {
                eTo.maxCount(this.getMaxCount());
            }
            if (this.getClientToken() != null) {
                eTo.clientToken(this.getClientToken());
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EC2TemplateOptions that = (EC2TemplateOptions)EC2TemplateOptions.class.cast(o);
        return super.equals((Object)that) && Objects.equal(this.groupNames, that.groupNames) && Objects.equal((Object)this.keyPair, (Object)that.keyPair) && Objects.equal((Object)this.noKeyPair, (Object)that.noKeyPair) && Objects.equal(this.userData, that.userData) && Objects.equal(this.blockDeviceMappings, that.blockDeviceMappings) && Objects.equal((Object)this.maxCount, (Object)that.maxCount) && Objects.equal((Object)this.clientToken, (Object)that.clientToken);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.groupNames, this.keyPair, this.noKeyPair, this.userData, this.userData, this.blockDeviceMappings, this.maxCount, this.clientToken});
    }

    public Objects.ToStringHelper string() {
        ImmutableSet mappings;
        Objects.ToStringHelper toString = super.string();
        if (!this.groupNames.isEmpty()) {
            toString.add("groupNames", this.groupNames);
        }
        if (this.noKeyPair) {
            toString.add("noKeyPair", this.noKeyPair);
        }
        toString.add("keyPair", (Object)this.keyPair);
        if (this.userData != null && !this.userData.isEmpty()) {
            toString.add("userDataCksum", (Object)Hashing.crc32().hashBytes(Bytes.toArray(this.userData)));
        }
        if (!(mappings = this.blockDeviceMappings.build()).isEmpty()) {
            toString.add("blockDeviceMappings", (Object)mappings);
        }
        if (this.maxCount != null && this.maxCount > 0) {
            toString.add("maxCount", (Object)this.maxCount);
        }
        if (this.clientToken != null) {
            toString.add("clientToken", (Object)this.clientToken);
        }
        return toString;
    }

    public EC2TemplateOptions securityGroups(String ... groupNames) {
        return this.securityGroups((Iterable)ImmutableSet.copyOf((Object[])groupNames));
    }

    public EC2TemplateOptions securityGroups(Iterable<String> groupNames) {
        Preconditions.checkArgument((!Iterables.isEmpty(groupNames) ? 1 : 0) != 0, (Object)"you must specify at least one security group");
        for (String groupId : groupNames) {
            Preconditions.checkNotNull((Object)Strings.emptyToNull((String)groupId), (Object)"all security groups must be non-empty");
        }
        this.groupNames = ImmutableSet.copyOf(groupNames);
        return this;
    }

    public EC2TemplateOptions userData(byte[] unencodedData) {
        Preconditions.checkArgument((((byte[])Preconditions.checkNotNull((Object)unencodedData, (Object)"unencodedData")).length <= 16384 ? 1 : 0) != 0, (Object)"userData cannot be larger than 16kb");
        this.userData = Bytes.asList((byte[])unencodedData);
        return this;
    }

    public EC2TemplateOptions keyPair(String keyPair) {
        Preconditions.checkState((!this.noKeyPair ? 1 : 0) != 0, (Object)"you cannot specify both options keyPair and noKeyPair");
        this.keyPair = (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)keyPair), (Object)"use noKeyPair option to request boot without a keypair");
        return this;
    }

    public EC2TemplateOptions noKeyPair() {
        Preconditions.checkState((this.keyPair == null ? 1 : 0) != 0, (Object)"you cannot specify both options keyPair and noKeyPair");
        this.noKeyPair = true;
        return this;
    }

    public EC2TemplateOptions mapEBSSnapshotToDeviceName(String deviceName, String snapshotId, @Nullable Integer sizeInGib, boolean deleteOnTermination) {
        return this.mapEBSSnapshotToDeviceName(deviceName, snapshotId, sizeInGib, deleteOnTermination, null, null, false);
    }

    public EC2TemplateOptions mapEBSSnapshotToDeviceName(String deviceName, String snapshotId, @Nullable Integer sizeInGib, boolean deleteOnTermination, @Nullable String volumeType, @Nullable Integer iops, boolean encrypted) {
        this.blockDeviceMappings.add((Object)new BlockDeviceMapping.MapEBSSnapshotToDevice(deviceName, snapshotId, sizeInGib, deleteOnTermination, volumeType, iops, encrypted));
        return this;
    }

    public EC2TemplateOptions mapNewVolumeToDeviceName(String deviceName, int sizeInGib, boolean deleteOnTermination) {
        return this.mapNewVolumeToDeviceName(deviceName, sizeInGib, deleteOnTermination, null, null, false);
    }

    public EC2TemplateOptions mapNewVolumeToDeviceName(String deviceName, int sizeInGib, boolean deleteOnTermination, @Nullable String volumeType, @Nullable Integer iops, boolean encrypted) {
        this.blockDeviceMappings.add((Object)new BlockDeviceMapping.MapNewVolumeToDevice(deviceName, sizeInGib, deleteOnTermination, volumeType, iops, encrypted));
        return this;
    }

    public EC2TemplateOptions mapEphemeralDeviceToDeviceName(String deviceName, String virtualName) {
        this.blockDeviceMappings.add((Object)new BlockDeviceMapping.MapEphemeralDeviceToDevice(deviceName, virtualName));
        return this;
    }

    public EC2TemplateOptions unmapDeviceNamed(String deviceName) {
        this.blockDeviceMappings.add((Object)new BlockDeviceMapping.UnmapDeviceNamed(deviceName));
        return this;
    }

    public EC2TemplateOptions blockDeviceMappings(Iterable<? extends BlockDeviceMapping> blockDeviceMappings) {
        this.blockDeviceMappings.addAll((Iterable)Preconditions.checkNotNull(blockDeviceMappings, (Object)"blockDeviceMappings"));
        return this;
    }

    public EC2TemplateOptions maxCount(Integer maxCount) {
        this.maxCount = maxCount;
        return this;
    }

    public EC2TemplateOptions clientToken(String clientToken) {
        this.clientToken = (String)Preconditions.checkNotNull((Object)clientToken, (Object)"clientToken");
        return this;
    }

    public EC2TemplateOptions blockOnPort(int port, int seconds) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public EC2TemplateOptions inboundPorts(int ... ports) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public EC2TemplateOptions authorizePublicKey(String publicKey) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public EC2TemplateOptions installPrivateKey(String privateKey) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    public EC2TemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    public EC2TemplateOptions dontAuthorizePublicKey() {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    public EC2TemplateOptions nameTask(String name) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.nameTask(name));
    }

    public EC2TemplateOptions runAsRoot(boolean runAsRoot) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    public EC2TemplateOptions runScript(Statement script) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.runScript(script));
    }

    public EC2TemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    public EC2TemplateOptions overrideLoginPassword(String password) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    public EC2TemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    public EC2TemplateOptions overrideLoginUser(String loginUser) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    public EC2TemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    public EC2TemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public EC2TemplateOptions userMetadata(String key, String value) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public EC2TemplateOptions nodeNames(Iterable<String> nodeNames) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.nodeNames(nodeNames));
    }

    public EC2TemplateOptions networks(Iterable<String> networks) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.networks(networks));
    }

    public EC2TemplateOptions runScript(String script) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.runScript(script));
    }

    public EC2TemplateOptions tags(Iterable<String> tags) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.tags(tags));
    }

    public EC2TemplateOptions wrapInInitScript(boolean wrapInInitScript) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.wrapInInitScript(wrapInInitScript));
    }

    public EC2TemplateOptions blockOnComplete(boolean blockOnComplete) {
        return (EC2TemplateOptions)EC2TemplateOptions.class.cast(super.blockOnComplete(blockOnComplete));
    }

    public Set<String> getGroups() {
        return this.groupNames;
    }

    public String getKeyPair() {
        return this.keyPair;
    }

    public boolean shouldAutomaticallyCreateKeyPair() {
        return !this.noKeyPair;
    }

    public byte[] getUserData() {
        return this.userData == null ? null : Bytes.toArray(this.userData);
    }

    public Set<BlockDeviceMapping> getBlockDeviceMappings() {
        return this.blockDeviceMappings.build();
    }

    public int getMaxCount() {
        return this.maxCount != null ? this.maxCount : 0;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public static class Builder
    extends TemplateOptions.Builder {
        public static EC2TemplateOptions blockDeviceMappings(Set<? extends BlockDeviceMapping> blockDeviceMappings) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.blockDeviceMappings(blockDeviceMappings);
        }

        public static EC2TemplateOptions mapEBSSnapshotToDeviceName(String deviceName, String snapshotId, @Nullable Integer sizeInGib, boolean deleteOnTermination) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.mapEBSSnapshotToDeviceName(deviceName, snapshotId, sizeInGib, deleteOnTermination);
        }

        public static EC2TemplateOptions mapNewVolumeToDeviceName(String deviceName, int sizeInGib, boolean deleteOnTermination) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.mapNewVolumeToDeviceName(deviceName, sizeInGib, deleteOnTermination);
        }

        public static EC2TemplateOptions mapEphemeralDeviceToDeviceName(String deviceName, String virtualName) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.mapEphemeralDeviceToDeviceName(deviceName, virtualName);
        }

        public static EC2TemplateOptions unmapDeviceNamed(String deviceName) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.unmapDeviceNamed(deviceName);
        }

        public static EC2TemplateOptions securityGroups(String ... groupNames) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.securityGroups(groupNames));
        }

        public static EC2TemplateOptions securityGroups(Iterable<String> groupNames) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.securityGroups((Iterable)groupNames));
        }

        public static EC2TemplateOptions keyPair(String keyPair) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.keyPair(keyPair));
        }

        public static EC2TemplateOptions userData(byte[] unencodedData) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.userData(unencodedData));
        }

        public static EC2TemplateOptions noKeyPair() {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.noKeyPair());
        }

        public static EC2TemplateOptions inboundPorts(int ... ports) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static EC2TemplateOptions blockOnPort(int port, int seconds) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static EC2TemplateOptions installPrivateKey(String rsaKey) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.installPrivateKey(rsaKey));
        }

        public static EC2TemplateOptions authorizePublicKey(String rsaKey) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.authorizePublicKey(rsaKey));
        }

        public static EC2TemplateOptions userMetadata(Map<String, String> userMetadata) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static EC2TemplateOptions nodeNames(Iterable<String> nodeNames) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.nodeNames((Iterable)nodeNames));
        }

        public static EC2TemplateOptions networks(Iterable<String> networks) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return (EC2TemplateOptions)EC2TemplateOptions.class.cast(options.networks((Iterable)networks));
        }

        public static EC2TemplateOptions overrideLoginUser(String user) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.overrideLoginUser(user);
        }

        public static EC2TemplateOptions overrideLoginPassword(String password) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.overrideLoginPassword(password);
        }

        public static EC2TemplateOptions overrideLoginPrivateKey(String privateKey) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static EC2TemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        public static EC2TemplateOptions overrideLoginCredentials(LoginCredentials credentials) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.overrideLoginCredentials(credentials);
        }

        public static EC2TemplateOptions nameTask(String name) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.nameTask(name);
        }

        public static EC2TemplateOptions runAsRoot(boolean value) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.runAsRoot(value);
        }

        public static EC2TemplateOptions tags(Iterable<String> tags) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.tags((Iterable)tags);
        }

        public static EC2TemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.blockUntilRunning(blockUntilRunning);
        }

        public static EC2TemplateOptions runScript(Statement script) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.runScript(script);
        }

        public static EC2TemplateOptions runScript(String script) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.runScript(script);
        }

        public static EC2TemplateOptions userMetadata(String key, String value) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.userMetadata(key, value);
        }

        public static EC2TemplateOptions blockOnComplete(boolean value) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.blockOnComplete(value);
        }

        public static EC2TemplateOptions maxCount(Integer maxCount) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.maxCount(maxCount);
        }

        public static EC2TemplateOptions clientToken(String clientToken) {
            EC2TemplateOptions options = new EC2TemplateOptions();
            return options.clientToken(clientToken);
        }
    }
}

