/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.domain.Location;
import org.jclouds.elasticstack.ElasticStackApi;
import org.jclouds.elasticstack.compute.ElasticStackComputeServiceAdapter;
import org.jclouds.elasticstack.compute.functions.ServerInfoToNodeMetadata;
import org.jclouds.elasticstack.compute.functions.StandardDriveToWellKnownImage;
import org.jclouds.elasticstack.compute.functions.WellKnownImageToImage;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.domain.ServerInfo;
import org.jclouds.elasticstack.domain.StandardDrive;
import org.jclouds.elasticstack.domain.WellKnownImage;
import org.jclouds.elasticstack.predicates.DriveClaimed;
import org.jclouds.elasticstack.suppliers.WellKnownImageSupplier;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.suppliers.MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.util.Predicates2;

public class ElasticStackComputeServiceContextModule
extends ComputeServiceAdapterContextModule<ServerInfo, Hardware, DriveInfo, Location> {
    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<ServerInfo, Hardware, DriveInfo, Location>>(){}).to(ElasticStackComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<ServerInfo, NodeMetadata>>(){}).to(ServerInfoToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Image, Image>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
        this.bind((TypeLiteral)new TypeLiteral<Function<Hardware, Hardware>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
        this.bind((TypeLiteral)new TypeLiteral<Function<Location, Location>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
        this.bind((TypeLiteral)new TypeLiteral<Function<Device, Volume>>(){}).to(ServerInfoToNodeMetadata.DeviceToVolume.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Server, String>>(){}).to(ServerInfoToNodeMetadata.GetImageIdFromServer.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<DriveInfo, Image>>(){}).to(WellKnownImageToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<StandardDrive, WellKnownImage>>(){}).to(StandardDriveToWellKnownImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<List<WellKnownImage>>>(){}).to(WellKnownImageSupplier.class);
    }

    @Provides
    @Singleton
    protected LoadingCache<String, DriveInfo> cache(GetDrive getDrive) {
        return CacheBuilder.newBuilder().build((CacheLoader)getDrive);
    }

    @Singleton
    @Provides
    @Memoized
    protected Supplier<Map<String, WellKnownImage>> provideImages(@Named(value="jclouds.session-interval") long seconds, final @Memoized Supplier<List<WellKnownImage>> wellKnownImageSupplier) throws IOException {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<Map<String, WellKnownImage>>(){

            public Map<String, WellKnownImage> get() {
                return Maps.uniqueIndex((Iterable)((Iterable)wellKnownImageSupplier.get()), (Function)new Function<WellKnownImage, String>(){

                    public String apply(WellKnownImage input) {
                        return input.getUuid();
                    }
                });
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    @Singleton
    @Provides
    @Memoized
    protected Supplier<List<WellKnownImage>> provideWellKnownImageSupplier(AtomicReference<AuthorizationException> authException, @Named(value="jclouds.session-interval") long seconds, WellKnownImageSupplier uncached) throws IOException {
        return MemoizedRetryOnTimeOutButNotOnAuthorizationExceptionSupplier.create(authException, (Supplier)uncached, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    protected Predicate<DriveInfo> supplyDriveUnclaimed(DriveClaimed driveClaimed, ComputeServiceConstants.Timeouts timeouts) {
        return Predicates2.retry((Predicate)Predicates.not((Predicate)driveClaimed), (long)timeouts.nodeRunning, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Singleton
    public static class GetDrive
    extends CacheLoader<String, DriveInfo> {
        private final ElasticStackApi client;

        @Inject
        public GetDrive(ElasticStackApi client) {
            this.client = client;
        }

        public DriveInfo load(String input) {
            return this.client.getDriveInfo(input);
        }
    }
}

