/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.javax.annotation.Nullable;

public class WellKnownImage {
    public static final String DEFAULT_USER = "toor";
    private final String loginUser;
    private final String uuid;
    private final String description;
    private final OsFamily osFamily;
    private final String osVersion;
    private final int size;
    private final boolean is64bit;

    public static Builder builder() {
        return new Builder();
    }

    public WellKnownImage(@Nullable String loginUser, String uuid, String description, OsFamily osFamily, @Nullable String osVersion, int size, @Nullable Boolean is64bit) {
        this.loginUser = (String)Objects.firstNonNull((Object)loginUser, (Object)DEFAULT_USER);
        this.uuid = (String)Preconditions.checkNotNull((Object)uuid, (Object)"uuid cannot be null");
        this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description cannot be null");
        this.osFamily = (OsFamily)Preconditions.checkNotNull((Object)osFamily, (Object)"osFamily cannot be null");
        this.osVersion = osVersion;
        this.size = size;
        this.is64bit = (Boolean)Objects.firstNonNull((Object)is64bit, (Object)Boolean.TRUE);
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getDescription() {
        return this.description;
    }

    public OsFamily getOsFamily() {
        return this.osFamily;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public int getSize() {
        return this.size;
    }

    public boolean is64bit() {
        return this.is64bit;
    }

    public String getLoginUser() {
        return this.loginUser;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.uuid, this.description, this.osFamily, this.osVersion, this.size, this.is64bit, this.loginUser});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WellKnownImage)) {
            return false;
        }
        WellKnownImage that = (WellKnownImage)obj;
        return Objects.equal((Object)this.loginUser, (Object)that.loginUser) && Objects.equal((Object)this.uuid, (Object)that.uuid) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.osFamily, (Object)that.osFamily) && Objects.equal((Object)this.osVersion, (Object)that.osVersion) && Objects.equal((Object)this.size, (Object)that.size) && Objects.equal((Object)this.is64bit, (Object)that.is64bit);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("uuid", (Object)this.uuid).add("description", (Object)this.description).add("osFamily", (Object)this.osFamily).add("osVersion", (Object)this.osVersion).add("size", this.size).add("is64bit", this.is64bit).add("loginUser", (Object)this.loginUser).toString();
    }

    public static class Builder {
        private String loginUser;
        private String uuid;
        private String description;
        private OsFamily osFamily;
        private String osVersion;
        private int size;
        private boolean is64bit;

        public Builder loginUser(String loginUser) {
            this.loginUser = loginUser;
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder osFamily(OsFamily osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        public Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public Builder is64bit(boolean is64bit) {
            this.is64bit = is64bit;
            return this;
        }

        public WellKnownImage build() {
            return new WellKnownImage(this.loginUser, this.uuid, this.description, this.osFamily, this.osVersion, this.size, this.is64bit);
        }
    }
}

