/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.domain.Address;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.ServerInRegion;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.util.InetAddresses2;

public class ServerInRegionToNodeMetadata
implements Function<ServerInRegion, NodeMetadata> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected Map<Server.Status, NodeMetadata.Status> toPortableNodeStatus;
    protected final Supplier<Map<String, Location>> locationIndex;
    protected final Supplier<Set<? extends Image>> images;
    protected final Supplier<Set<? extends Hardware>> hardwares;
    protected final GroupNamingConvention nodeNamingConvention;
    private static final Predicate<Address> isPrivateAddress = new Predicate<Address>(){

        public boolean apply(Address in) {
            return InetAddresses2.IsPrivateIPAddress.INSTANCE.apply(in.getAddr());
        }
    };
    public static final Predicate<String> isInet4Address = new Predicate<String>(){

        public boolean apply(String input) {
            try {
                return InetAddresses.forString((String)input) instanceof Inet4Address;
            }
            catch (IllegalArgumentException e) {
                return true;
            }
        }
    };

    @Inject
    public ServerInRegionToNodeMetadata(Map<Server.Status, NodeMetadata.Status> toPortableNodeStatus, Supplier<Map<String, Location>> locationIndex, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwares, GroupNamingConvention.Factory namingConvention) {
        this.toPortableNodeStatus = (Map)Preconditions.checkNotNull(toPortableNodeStatus, (Object)"toPortableNodeStatus");
        this.nodeNamingConvention = ((GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention")).createWithoutPrefix();
        this.locationIndex = (Supplier)Preconditions.checkNotNull(locationIndex, (Object)"locationIndex");
        this.images = (Supplier)Preconditions.checkNotNull(images, (Object)"images");
        this.hardwares = (Supplier)Preconditions.checkNotNull(hardwares, (Object)"hardwares");
    }

    public NodeMetadata apply(ServerInRegion serverInRegion) {
        Location region = (Location)((Map)this.locationIndex.get()).get(serverInRegion.getRegion());
        Preconditions.checkState((region != null ? 1 : 0) != 0, (String)"location %s not in locationIndex: %s", (Object[])new Object[]{serverInRegion.getRegion(), this.locationIndex.get()});
        Server from = serverInRegion.getServer();
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.id(serverInRegion.slashEncode());
        builder.providerId(from.getId());
        builder.name(from.getName());
        builder.hostname(from.getName());
        builder.location(from.getHostId() != null ? new LocationBuilder().scope(LocationScope.HOST).id(from.getHostId()).description(from.getHostId()).parent(region).build() : region);
        builder.group(ComputeServiceUtils.groupFromMapOrName(from.getMetadata(), (String)from.getName(), (GroupNamingConvention)this.nodeNamingConvention));
        ComputeServiceUtils.addMetadataAndParseTagsFromCommaDelimitedValue((NodeMetadataBuilder)builder, from.getMetadata());
        if (from.getImage() != null) {
            builder.imageId(RegionAndId.fromRegionAndId(serverInRegion.getRegion(), from.getImage().getId()).slashEncode());
        }
        builder.operatingSystem(this.findOperatingSystemForServerOrNull(serverInRegion));
        builder.hardware(this.findHardwareForServerOrNull(serverInRegion));
        builder.status(this.toPortableNodeStatus.get((Object)from.getStatus()));
        HashSet addresses = Sets.newHashSet((Iterable)from.getAddresses().values());
        if (from.getAccessIPv4() != null) {
            addresses.add(Address.createV4(from.getAccessIPv4()));
        }
        if (from.getAccessIPv6() != null) {
            addresses.add(Address.createV6(from.getAccessIPv6()));
        }
        builder.publicAddresses(Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)addresses, (Predicate)Predicates.not(isPrivateAddress)), (Function)AddressToStringTransformationFunction.INSTANCE), isInet4Address));
        builder.privateAddresses(Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)addresses, isPrivateAddress), (Function)AddressToStringTransformationFunction.INSTANCE), isInet4Address));
        for (Link link : from.getLinks()) {
            if (!link.getRelation().equals((Object)Link.Relation.SELF)) continue;
            builder.uri(link.getHref());
        }
        return builder.build();
    }

    protected Hardware findHardwareForServerOrNull(ServerInRegion serverInRegion) {
        return (Hardware)this.findObjectOfTypeForServerOrNull((Set)this.hardwares.get(), "hardware", serverInRegion.getServer().getFlavor().getId(), serverInRegion);
    }

    protected OperatingSystem findOperatingSystemForServerOrNull(ServerInRegion serverInRegion) {
        if (serverInRegion.getServer().getImage() != null) {
            Image image = (Image)this.findObjectOfTypeForServerOrNull((Set)this.images.get(), "image", serverInRegion.getServer().getImage().getId(), serverInRegion);
            return image != null ? image.getOperatingSystem() : null;
        }
        return null;
    }

    public <T extends ComputeMetadata> T findObjectOfTypeForServerOrNull(Set<? extends T> supply, String type, final String objectId, final RegionAndId serverInRegion) {
        try {
            return (T)((ComputeMetadata)Iterables.find(supply, (Predicate)new Predicate<T>(){

                public boolean apply(T input) {
                    return input.getId().equals(RegionAndId.fromRegionAndId(serverInRegion.getRegion(), objectId).slashEncode());
                }
            }));
        }
        catch (NoSuchElementException e) {
            this.logger.trace("could not find %s with id(%s) for server(%s)", new Object[]{type, objectId, serverInRegion});
            return null;
        }
    }

    private static enum AddressToStringTransformationFunction implements Function<Address, String>
    {
        INSTANCE;


        public String apply(Address address) {
            return address.getAddr();
        }
    }
}

