/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class Host {
    @Named(value="host_name")
    private final String name;
    private final String service;
    private final String zone;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromHost(this);
    }

    @ConstructorProperties(value={"host_name", "service", "zone"})
    protected Host(@Nullable String name, @Nullable String service, @Nullable String zone) {
        this.name = name;
        this.service = service;
        this.zone = zone;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getService() {
        return this.service;
    }

    @Nullable
    public String getZone() {
        return this.zone;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.service, this.zone});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Host that = (Host)Host.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.service, (Object)that.service) && Objects.equal((Object)this.zone, (Object)that.zone);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("service", (Object)this.service).add("zone", (Object)this.zone);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected String service;
        protected String zone;

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T service(String service) {
            this.service = service;
            return this.self();
        }

        public T zone(String zone) {
            this.zone = zone;
            return this.self();
        }

        public Host build() {
            return new Host(this.name, this.service, this.zone);
        }

        public T fromHost(Host in) {
            return ((Builder)((Builder)this.name(in.getName())).service(in.getService())).zone(in.getZone());
        }
    }
}

