/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.trove.v1.binders.BindCreateDatabaseToJson;
import org.jclouds.openstack.trove.v1.functions.ParseDatabaseListForUser;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SkipEncoding;

@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class})
public interface DatabaseApi {
    @Named(value="database:create")
    @POST
    @Path(value="/databases")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @MapBinder(value=BindCreateDatabaseToJson.class)
    public boolean create(@PayloadParam(value="database") String var1);

    @Named(value="database:create")
    @POST
    @Path(value="/databases")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    @MapBinder(value=BindCreateDatabaseToJson.class)
    public boolean create(@PayloadParam(value="database") String var1, @PayloadParam(value="character_set") String var2, @PayloadParam(value="collate") String var3);

    @Named(value="databases:delete")
    @DELETE
    @Path(value="/databases/{name}")
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="name") String var1);

    @Named(value="database:list")
    @GET
    @Path(value="/databases")
    @ResponseParser(value=ParseDatabaseListForUser.class)
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<String> list();
}

