/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.trove.v1.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;

public class ParseDatabaseListForUser
implements Function<HttpResponse, FluentIterable<String>> {
    private final ParseJson<Map<String, List<Map<String, String>>>> json;

    @Inject
    ParseDatabaseListForUser(ParseJson<Map<String, List<Map<String, String>>>> json) {
        this.json = (ParseJson)Preconditions.checkNotNull(json, (Object)"json");
    }

    public FluentIterable<String> apply(HttpResponse from) {
        ArrayList resultDatabases = Lists.newArrayList();
        Map result = (Map)this.json.apply(from);
        for (Map database : (List)result.get("databases")) {
            resultDatabases.add(database.get("name"));
        }
        return FluentIterable.from((Iterable)resultDatabases);
    }
}

