/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.binders.BindMapToHeadersWithPrefix;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;
import org.jclouds.s3.domain.S3Object;

@Singleton
public class BindS3ObjectMetadataToRequest
implements Binder {
    protected final BindMapToHeadersWithPrefix metadataPrefixer;

    @Inject
    public BindS3ObjectMetadataToRequest(BindMapToHeadersWithPrefix metadataPrefixer) {
        this.metadataPrefixer = (BindMapToHeadersWithPrefix)Preconditions.checkNotNull((Object)metadataPrefixer, (Object)"metadataPrefixer");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof S3Object), (String)"this binder is only valid for S3Object!, not %s", (Object[])new Object[]{input});
        Preconditions.checkNotNull(request, (Object)"request");
        S3Object s3Object = (S3Object)S3Object.class.cast(input);
        Preconditions.checkArgument((s3Object.getMetadata().getKey() != null ? 1 : 0) != 0, (Object)"s3Object.getMetadata().getKey() must be set!");
        Preconditions.checkArgument((s3Object.getPayload().getContentMetadata().getContentLength() != null ? 1 : 0) != 0, (Object)"contentLength must be set, streaming not supported");
        Preconditions.checkArgument((s3Object.getPayload().getContentMetadata().getContentLength() <= 0x140000000L ? 1 : 0) != 0, (Object)"maximum size for put object is 5GB");
        request = this.metadataPrefixer.bindToRequest(request, s3Object.getMetadata().getUserMetadata());
        if (s3Object.getMetadata().getCacheControl() != null) {
            request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("Cache-Control", new String[]{s3Object.getMetadata().getCacheControl()})).build();
        }
        return request;
    }
}

