/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.base.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ReturnStringIf2xx;

@Singleton
public class ETagFromHttpResponseViaRegex
implements Function<HttpResponse, String> {
    private static Pattern pattern = Pattern.compile("<ETag>([\\S&&[^<]]+)</ETag>");
    private static String ESCAPED_QUOTE = "&quot;";
    private final ReturnStringIf2xx returnStringIf200;

    @Inject
    ETagFromHttpResponseViaRegex(ReturnStringIf2xx returnStringIf200) {
        this.returnStringIf200 = returnStringIf200;
    }

    public String apply(HttpResponse response) {
        Matcher matcher;
        String value = null;
        String content = this.returnStringIf200.apply(response);
        if (content != null && (matcher = pattern.matcher(content)).find() && (value = matcher.group(1)).indexOf(ESCAPED_QUOTE) != -1) {
            value = value.replace(ESCAPED_QUOTE, "\"");
        }
        return value;
    }
}

