/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.apachehc;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.inject.Inject;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.IOExceptionRetryHandler;
import org.jclouds.http.apachehc.ApacheHCUtils;
import org.jclouds.http.handlers.DelegatingErrorHandler;
import org.jclouds.http.handlers.DelegatingRetryHandler;
import org.jclouds.http.internal.BaseHttpCommandExecutorService;
import org.jclouds.http.internal.HttpWire;
import org.jclouds.io.ByteStreams2;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.InputStreamPayload;

public class ApacheHCHttpCommandExecutorService
extends BaseHttpCommandExecutorService<HttpUriRequest> {
    private final HttpClient client;
    private final ApacheHCUtils apacheHCUtils;

    @Inject
    ApacheHCHttpCommandExecutorService(HttpUtils utils, ContentMetadataCodec contentMetadataCodec, DelegatingRetryHandler retryHandler, IOExceptionRetryHandler ioRetryHandler, DelegatingErrorHandler errorHandler, HttpWire wire, HttpClient client) {
        super(utils, contentMetadataCodec, retryHandler, ioRetryHandler, errorHandler, wire);
        this.client = client;
        this.apacheHCUtils = new ApacheHCUtils(contentMetadataCodec);
    }

    protected HttpUriRequest convert(HttpRequest request) throws IOException {
        HttpUriRequest returnVal = this.apacheHCUtils.convertToApacheRequest(request);
        if (request.getPayload() != null && request.getPayload().getContentMetadata().getContentMD5() != null) {
            String md5 = BaseEncoding.base64().encode(ByteStreams2.hashAndClose((InputStream)request.getPayload().openStream(), (HashFunction)Hashing.md5()).asBytes());
            returnVal.addHeader("Content-MD5", md5);
        }
        return returnVal;
    }

    protected HttpResponse invoke(HttpUriRequest nativeRequest) throws IOException {
        org.apache.http.HttpResponse apacheResponse = this.executeRequest(nativeRequest);
        InputStreamPayload payload = null;
        if (apacheResponse.getEntity() != null) {
            try {
                payload = Payloads.newInputStreamPayload((InputStream)apacheResponse.getEntity().getContent());
                if (apacheResponse.getEntity().getContentLength() >= 0L) {
                    payload.getContentMetadata().setContentLength(Long.valueOf(apacheResponse.getEntity().getContentLength()));
                }
                if (apacheResponse.getEntity().getContentType() != null) {
                    payload.getContentMetadata().setContentType(apacheResponse.getEntity().getContentType().getValue());
                }
            }
            catch (IOException e) {
                this.logger.warn((Throwable)e, "couldn't receive payload for request: %s", new Object[]{nativeRequest.getRequestLine()});
                throw e;
            }
        }
        LinkedHashMultimap headers = LinkedHashMultimap.create();
        for (Header header : apacheResponse.getAllHeaders()) {
            headers.put((Object)header.getName(), (Object)header.getValue());
        }
        if (payload != null) {
            this.contentMetadataCodec.fromHeaders(payload.getContentMetadata(), (Multimap)headers);
        }
        return ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(apacheResponse.getStatusLine().getStatusCode()).message(apacheResponse.getStatusLine().getReasonPhrase()).payload((Payload)payload)).headers(HttpUtils.filterOutContentHeaders((Multimap)headers))).build();
    }

    private org.apache.http.HttpResponse executeRequest(HttpUriRequest nativeRequest) throws IOException, ClientProtocolException {
        URI endpoint = URI.create(nativeRequest.getRequestLine().getUri());
        HttpHost host = new HttpHost(endpoint.getHost(), endpoint.getPort(), endpoint.getScheme());
        org.apache.http.HttpResponse nativeResponse = this.client.execute(host, (org.apache.http.HttpRequest)nativeRequest);
        return nativeResponse;
    }

    protected void cleanup(HttpUriRequest nativeResponse) {
    }
}

