/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.date.joda;

import java.util.Date;
import java.util.Locale;
import javax.inject.Singleton;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Singleton
public class JodaDateService
implements DateService {
    private static final DateTimeFormatter rfc822DateFormatter = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss 'GMT'").withLocale(Locale.US).withZone(DateTimeZone.forID((String)"GMT"));
    private static final DateTimeFormatter cDateFormatter = DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss Z yyyy").withLocale(Locale.US).withZone(DateTimeZone.forID((String)"GMT"));
    private static final DateTimeFormatter iso8601SecondsDateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ").withLocale(Locale.US).withZone(DateTimeZone.forID((String)"GMT"));
    private static final DateTimeFormatter iso8601DateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ").withLocale(Locale.US).withZone(DateTimeZone.forID((String)"GMT"));
    private static final DateTimeFormatter rfc1123DateFormat = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyyy HH:mm:ss Z").withLocale(Locale.US).withZone(DateTimeZone.forID((String)"GMT"));

    public final Date fromSeconds(long seconds) {
        return new Date(seconds * 1000L);
    }

    public final String cDateFormat(Date dateTime) {
        return cDateFormatter.print((ReadableInstant)new DateTime((Object)dateTime));
    }

    public final String cDateFormat() {
        return this.cDateFormat(new Date());
    }

    public final Date cDateParse(String toParse) {
        return cDateFormatter.parseDateTime(toParse).toDate();
    }

    public final String rfc822DateFormat(Date dateTime) {
        return rfc822DateFormatter.print((ReadableInstant)new DateTime((Object)dateTime));
    }

    public final String rfc822DateFormat() {
        return this.rfc822DateFormat(new Date());
    }

    public final Date rfc822DateParse(String toParse) {
        return rfc822DateFormatter.parseDateTime(toParse).toDate();
    }

    public final String iso8601SecondsDateFormat(Date dateTime) {
        String parsed = iso8601SecondsDateFormatter.print((ReadableInstant)new DateTime((Object)dateTime));
        String tz = DateUtils.findTZ((String)parsed);
        if (tz.equals("+0000")) {
            parsed = DateUtils.trimTZ((String)parsed) + "Z";
        }
        return parsed;
    }

    public final String iso8601SecondsDateFormat() {
        return this.iso8601SecondsDateFormat(new Date());
    }

    public final String iso8601DateFormat(Date date) {
        String parsed = iso8601DateFormatter.print((ReadableInstant)new DateTime((Object)date));
        String tz = DateUtils.findTZ((String)parsed);
        if (tz.equals("+0000")) {
            parsed = DateUtils.trimTZ((String)parsed) + "Z";
        }
        return parsed;
    }

    public final String iso8601DateFormat() {
        return this.iso8601DateFormat(new Date());
    }

    public final Date iso8601DateParse(String toParse) {
        if (toParse.length() < 10) {
            throw new IllegalArgumentException("incorrect date format " + toParse);
        }
        if ((toParse = this.adjustTz(toParse)).charAt(10) == ' ') {
            toParse = new StringBuilder(toParse).replace(10, 11, "T").toString();
        }
        return iso8601DateFormatter.parseDateTime(toParse).toDate();
    }

    private String adjustTz(String toParse) {
        String tz = DateUtils.findTZ((String)toParse);
        toParse = DateUtils.trimToMillis((String)toParse);
        toParse = DateUtils.trimTZ((String)toParse);
        toParse = toParse + tz;
        return toParse.replace("UTC", "");
    }

    public final Date iso8601SecondsDateParse(String toParse) {
        if (toParse.length() < 10) {
            throw new IllegalArgumentException("incorrect date format " + toParse);
        }
        toParse = this.adjustTz(toParse);
        return iso8601SecondsDateFormatter.parseDateTime(toParse).toDate();
    }

    public Date iso8601DateOrSecondsDateParse(String toParse) throws IllegalArgumentException {
        try {
            return this.iso8601DateParse(toParse);
        }
        catch (IllegalArgumentException orig) {
            try {
                return this.iso8601SecondsDateParse(toParse);
            }
            catch (IllegalArgumentException ignored) {
                throw orig;
            }
        }
    }

    public final String rfc1123DateFormat(Date dateTime) {
        return rfc1123DateFormat.print((ReadableInstant)new DateTime((Object)dateTime));
    }

    public final String rfc1123DateFormat() {
        return this.rfc1123DateFormat(new Date());
    }

    public final Date rfc1123DateParse(String toParse) {
        return rfc1123DateFormat.parseDateTime(toParse).toDate();
    }
}

