/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.functions.BlobName;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class BlobStoreUtils {
    private static Pattern keyFromContainer = Pattern.compile("/?[^/]+/(.*)");
    private static final BlobName blobName = new BlobName();

    public static <T> HttpRequest cleanRequest(HttpRequest returnVal) {
        Preconditions.checkNotNull((Object)returnVal, (Object)"http request");
        for (HttpRequestFilter filter : returnVal.getFilters()) {
            returnVal = filter.filter(returnVal);
        }
        return ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method(returnVal.getMethod()).endpoint(returnVal.getEndpoint()).headers(returnVal.getHeaders())).payload(returnVal.getPayload())).build();
    }

    public static String parseDirectoryFromPath(String path) {
        return ((String)Preconditions.checkNotNull((Object)path, (Object)"path")).substring(0, path.lastIndexOf(47));
    }

    public static String getNameFor(GeneratedHttpRequest request) {
        Matcher matcher;
        Preconditions.checkNotNull((Object)request, (Object)"request");
        List args = request.getInvocation().getArgs();
        if (args.size() >= 2 && args.get(0) instanceof String && args.get(1) instanceof String) {
            return args.get(1).toString();
        }
        if (args.size() >= 1 && args.get(0) instanceof String && (matcher = keyFromContainer.matcher(args.get(0).toString())).find()) {
            return matcher.group(1);
        }
        String objectKey = request.getEndpoint().getPath();
        if (objectKey.startsWith("/")) {
            objectKey = objectKey.substring(1);
        }
        return objectKey;
    }

    public static ListenableFuture<Void> createParentIfNeededAsync(AsyncBlobStore asyncBlobStore, String container, Blob blob) {
        Preconditions.checkNotNull((Object)asyncBlobStore, (Object)"asyncBlobStore");
        Preconditions.checkNotNull((Object)container, (Object)"container");
        String name = blobName.apply(blob);
        if (name.indexOf(47) > 0) {
            return asyncBlobStore.createDirectory(container, BlobStoreUtils.parseDirectoryFromPath(name));
        }
        return Futures.immediateFuture(null);
    }

    public static MutableBlobMetadata copy(MutableBlobMetadata in) {
        MutableBlobMetadataImpl metadata = new MutableBlobMetadataImpl(in);
        BlobStoreUtils.convertUserMetadataKeysToLowercase(metadata);
        return metadata;
    }

    public static MutableBlobMetadata copy(MutableBlobMetadata in, String newKey) {
        MutableBlobMetadata newMd = BlobStoreUtils.copy(in);
        newMd.setName(newKey);
        return newMd;
    }

    private static void convertUserMetadataKeysToLowercase(MutableBlobMetadata metadata) {
        HashMap lowerCaseUserMetadata = Maps.newHashMap();
        for (Map.Entry<String, String> entry : metadata.getUserMetadata().entrySet()) {
            lowerCaseUserMetadata.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        metadata.setUserMetadata(lowerCaseUserMetadata);
    }
}

